/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.sgraph.naming;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;
import org.yakindu.sct.model.sgraph.Choice;
import org.yakindu.sct.model.sgraph.CompositeElement;
import org.yakindu.sct.model.sgraph.Declaration;
import org.yakindu.sct.model.sgraph.Entry;
import org.yakindu.sct.model.sgraph.Exit;
import org.yakindu.sct.model.sgraph.FinalState;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.Scope;
import org.yakindu.sct.model.sgraph.ScopedElement;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.Synchronization;
import org.yakindu.sct.model.sgraph.Vertex;
import org.yakindu.sct.model.sgraph.naming.IdentifierConverter;

public class SGraphNameProvider
extends DefaultDeclarativeQualifiedNameProvider {
    private static final QualifiedName DEFAULT_ENTRY_NAME = QualifiedName.create((String)"_entry_Default");
    private static final QualifiedName DEFAULT_EXIT_NAME = QualifiedName.create((String)"_exit_Default");
    private static final String _FINAL_STATE_NAME = "_final_";
    private static final String _CHOICE_NAME = "_choice_";
    private static final String _SYNC_NAME = "_sync";
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private IdentifierConverter identifierConverter;

    protected Function<EObject, String> getResolver() {
        return SimpleAttributeResolver.NAME_RESOLVER;
    }

    public QualifiedName qualifiedName(Statechart ele) {
        String scName = ele.getName();
        if (Strings.isEmpty((String)scName)) {
            return null;
        }
        QualifiedName name = QualifiedName.create((String)this.identifierConverter.toIdentifier(ele.getName()));
        if (!Strings.isEmpty((String)ele.getNamespace())) {
            name = this.nameConverter.toQualifiedName(ele.getNamespace()).append(name);
        }
        return name;
    }

    public QualifiedName qualifiedName(Synchronization ele) {
        QualifiedName qualifiedNameFromConverter = null;
        if (!Strings.isEmpty((String)ele.getName())) {
            qualifiedNameFromConverter = QualifiedName.create((String)ele.getName());
        } else {
            LinkedList list = new LinkedList();
            Iterables.addAll(list, (Iterable)Iterables.filter(((Region)ele.eContainer()).getVertices(), Synchronization.class));
            qualifiedNameFromConverter = QualifiedName.create((String)(_SYNC_NAME + list.indexOf(ele)));
        }
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Choice ele) {
        ArrayList choiceList = new ArrayList();
        choiceList.addAll(Collections2.filter(((Region)ele.eContainer()).getVertices(), (Predicate)new Predicate<Vertex>(){

            public boolean apply(Vertex input) {
                return input instanceof Choice;
            }
        }));
        int index = choiceList.indexOf(ele);
        QualifiedName qualifiedNameFromConverter = QualifiedName.create((String)(_CHOICE_NAME + index));
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Entry ele) {
        QualifiedName name = DEFAULT_ENTRY_NAME;
        if (ele.getName() != null && !ele.getName().isEmpty()) {
            name = QualifiedName.create((String)ele.getName());
        }
        return this.getParentQualifiedName((EObject)ele, name);
    }

    public QualifiedName qualifiedName(Exit ele) {
        QualifiedName name = DEFAULT_EXIT_NAME;
        if (ele.getName() != null && !ele.getName().isEmpty()) {
            name = QualifiedName.create((String)ele.getName());
        }
        return this.getParentQualifiedName((EObject)ele, name);
    }

    protected QualifiedName getParentQualifiedName(EObject ele, QualifiedName childName) {
        EObject temp = ele;
        while (temp.eContainer() != null) {
            QualifiedName parentsQualifiedName = this.getFullyQualifiedName(temp = temp.eContainer());
            if (parentsQualifiedName == null) continue;
            return parentsQualifiedName.append(childName);
        }
        return childName;
    }

    public QualifiedName qualifiedName(Scope ele) {
        QualifiedName namespace;
        QualifiedName name = null;
        String nameString = (String)SimpleAttributeResolver.NAME_RESOLVER.apply((EObject)ele);
        if (!Strings.isEmpty((String)nameString)) {
            name = this.nameConverter.toQualifiedName(nameString);
        }
        if ((namespace = this.getNamespace(ele)) != null && name != null) {
            name = namespace.append(name);
        }
        return name;
    }

    public QualifiedName qualifiedName(FinalState ele) {
        QualifiedName qfn = null;
        qfn = Strings.isEmpty((String)ele.getName()) ? QualifiedName.create((String)_FINAL_STATE_NAME) : QualifiedName.create((String)this.identifierConverter.toIdentifier(ele.getName()));
        return this.getParentQualifiedName((EObject)ele, qfn);
    }

    public QualifiedName qualifiedName(State ele) {
        if (ele.getName() == null) {
            return null;
        }
        QualifiedName qualifiedNameFromConverter = QualifiedName.create((String)this.identifierConverter.toIdentifier(ele.getName()));
        return this.getParentQualifiedName(ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Region ele) {
        QualifiedName qualifiedNameFromConverter = null;
        if (ele.getName() == null || ele.getName().isEmpty()) {
            CompositeElement parent;
            int index;
            if (ele.eContainer() instanceof CompositeElement && (index = (parent = (CompositeElement)ele.eContainer()).getRegions().indexOf((Object)ele)) != -1) {
                qualifiedNameFromConverter = QualifiedName.create((String)("_region" + index));
            }
            if (qualifiedNameFromConverter == null) {
                return null;
            }
        } else {
            qualifiedNameFromConverter = QualifiedName.create((String)this.identifierConverter.toIdentifier(ele.getName()));
        }
        return this.getParentQualifiedName((EObject)ele, qualifiedNameFromConverter);
    }

    public QualifiedName qualifiedName(Declaration ele) {
        QualifiedName namespace;
        QualifiedName name = null;
        if (!Strings.isEmpty((String)ele.getName())) {
            name = this.nameConverter.toQualifiedName(ele.getName());
        }
        if ((namespace = this.getNamespace((EObject)ele)) != null && name != null) {
            name = namespace.append(name);
        }
        return name;
    }

    protected QualifiedName getNamespace(EObject child) {
        ScopedElement interfaceScope;
        QualifiedName name = null;
        if (!(child instanceof ScopedElement) && (interfaceScope = (ScopedElement)EcoreUtil2.getContainerOfType((EObject)child, ScopedElement.class)) != null && !Strings.isEmpty((String)interfaceScope.getNamespace())) {
            name = this.nameConverter.toQualifiedName(interfaceScope.getNamespace());
        }
        return name;
    }
}

