/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools.preferences;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MapProjectPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_DEFAULT_MAP_PROJECT = "useDefaultMapProject";
    public static final String SELECTED_MAP_PROJECT_PATH = "defaultMapProject";
    private Button alwaysPromptButton;
    private List projectList;
    private Label mapProjectSelectionDescription;
    private IProject[] workspaceMapProjects;
    private IPreferenceStore preferenceStore;

    protected Control createContents(Composite parent) {
        this.preferenceStore = RelEngPlugin.getDefault().getPreferenceStore();
        Composite topContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        topContainer.setLayout((Layout)layout);
        topContainer.setLayoutData((Object)new GridData(1808));
        GridData data = new GridData(768);
        Label pageDescription = SWTUtils.createLabel((Composite)topContainer, (String)Messages.getString("MapProjectPreferencePage.1"));
        pageDescription.setLayoutData((Object)data);
        this.alwaysPromptButton = new Button(topContainer, 32);
        this.alwaysPromptButton.setText(Messages.getString("MapProjectPreferencePage.0"));
        this.alwaysPromptButton.setLayoutData((Object)data);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapProjectPreferencePage.this.update();
            }
        };
        this.alwaysPromptButton.addSelectionListener((SelectionListener)selectionListener);
        this.mapProjectSelectionDescription = SWTUtils.createLabel((Composite)topContainer, (String)Messages.getString("MapProjectPreferencePage.2"));
        this.createMapProjectList(topContainer);
        this.initialButtonSetup();
        Dialog.applyDialogFont((Control)parent);
        return topContainer;
    }

    protected void update() {
        this.projectList.setEnabled(!this.alwaysPromptButton.getSelection());
        if (this.projectList.isEnabled()) {
            this.projectSelected();
            this.projectList.setFocus();
        } else {
            this.setValid(this.alwaysPromptButton.getSelection());
            this.setErrorMessage(null);
        }
        this.mapProjectSelectionDescription.setEnabled(!this.alwaysPromptButton.getSelection());
    }

    private void createMapProjectList(Composite aComposite) {
        MapFile[] mapFiles;
        this.projectList = new List(aComposite, 2820);
        GridData data = new GridData();
        data.heightHint = this.projectList.getItemHeight();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.projectList.setLayoutData((Object)data);
        HashSet<IProject> projects = new HashSet<IProject>();
        try {
            mapFiles = MapFile.findAllMapFiles((IResource)RelEngPlugin.getWorkspace().getRoot());
        }
        catch (CoreException coreException) {
            mapFiles = new MapFile[]{};
        }
        int i = 0;
        while (i < mapFiles.length) {
            projects.add(mapFiles[i].getFile().getProject());
            ++i;
        }
        this.workspaceMapProjects = projects.toArray(new IProject[projects.size()]);
        String[] projectNames = new String[this.workspaceMapProjects.length];
        int i2 = 0;
        while (i2 < this.workspaceMapProjects.length) {
            projectNames[i2] = this.workspaceMapProjects[i2].getName();
            ++i2;
        }
        this.projectList.setItems(projectNames);
        this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapProjectPreferencePage.this.projectSelected();
            }
        });
    }

    protected void projectSelected() {
        boolean isValid;
        block10: {
            int selectedIndex = this.projectList.getSelectionIndex();
            if (selectedIndex == -1) {
                this.setValid(false);
                return;
            }
            IProject selectedProject = this.workspaceMapProjects[selectedIndex];
            isValid = false;
            MapProject mapProject = null;
            try {
                try {
                    mapProject = new MapProject(selectedProject);
                    isValid = true;
                    if (mapProject.getValidMapFiles().length == 0) {
                        this.setMessage(Messages.getString("MapProjectPreferencePage.3"), 2);
                    }
                }
                catch (CoreException coreException) {
                    isValid = false;
                    if (mapProject != null) {
                        mapProject.dispose();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (mapProject != null) {
                    mapProject.dispose();
                }
                throw throwable;
            }
            if (mapProject != null) {
                mapProject.dispose();
            }
        }
        this.setValid(isValid);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.preferenceStore.setValue(USE_DEFAULT_MAP_PROJECT, !this.alwaysPromptButton.getSelection());
        if (this.projectList.getSelectionIndex() != -1) {
            String fullPath = this.workspaceMapProjects[this.projectList.getSelectionIndex()].getFullPath().toString();
            this.preferenceStore.setValue(SELECTED_MAP_PROJECT_PATH, fullPath);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.alwaysPromptButton.setSelection(true);
        this.update();
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this.preferenceStore;
    }

    private void initialButtonSetup() {
        int selectedMapProjectPathLength = this.preferenceStore.getString(SELECTED_MAP_PROJECT_PATH).length();
        if (selectedMapProjectPathLength <= 0) {
            this.preferenceStore.setValue(USE_DEFAULT_MAP_PROJECT, false);
        }
        if (this.preferenceStore.getBoolean(USE_DEFAULT_MAP_PROJECT) && selectedMapProjectPathLength > 0) {
            this.highlightDefaultMapProject();
        }
        this.alwaysPromptButton.setSelection(!this.preferenceStore.getBoolean(USE_DEFAULT_MAP_PROJECT));
        this.update();
    }

    private void highlightDefaultMapProject() {
        boolean isMapProjectSelected;
        String path;
        block13: {
            path = this.preferenceStore.getString(SELECTED_MAP_PROJECT_PATH);
            isMapProjectSelected = false;
            if (path.length() > 0) {
                MapProject selectedMapProject = null;
                try {
                    try {
                        selectedMapProject = new MapProject(ResourcesPlugin.getWorkspace().getRoot().getProject(path));
                        isMapProjectSelected = true;
                    }
                    catch (CoreException coreException) {
                        isMapProjectSelected = false;
                        if (selectedMapProject != null) {
                            selectedMapProject.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (selectedMapProject != null) {
                        selectedMapProject.dispose();
                    }
                    throw throwable;
                }
                if (selectedMapProject != null) {
                    selectedMapProject.dispose();
                }
            }
        }
        if (!isMapProjectSelected) {
            this.alwaysPromptButton.setEnabled(true);
            this.preferenceStore.setValue(USE_DEFAULT_MAP_PROJECT, false);
        } else {
            int i = 0;
            while (i < this.workspaceMapProjects.length) {
                if (path.equals(this.workspaceMapProjects[i].getFullPath().toString())) {
                    this.projectList.setSelection(i);
                    this.projectSelected();
                    return;
                }
                ++i;
            }
        }
    }
}

