/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.releng.tools.CVSTagHelper;
import org.eclipse.releng.tools.CompareLocalToMap;
import org.eclipse.releng.tools.MapProjectSelectionWizard;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;

public class ReplaceLocalFromMap
extends WorkspaceAction {
    private CVSTag[] tags;

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        if (super.isEnabledForCVSResource(cvsResource)) {
            String tag;
            String revision;
            ResourceSyncInfo info;
            return cvsResource.isFolder() || (info = cvsResource.getSyncInfo()) == null || info.getTag() == null || !(revision = info.getRevision()).equals(tag = info.getTag().getName());
        }
        return false;
    }

    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        IResource[] resources = this.getSelectedResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() != 4) {
                return false;
            }
            ++i;
        }
        return CompareLocalToMap.hasProjectFromMapFile();
    }

    protected void performReplace(IResource[] resources, IProgressMonitor monitor) throws TeamException, InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 100 * resources.length);
        try {
            if (this.tags.length != resources.length) {
                return;
            }
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                new ReplaceOperation(this.getTargetPart(), new IResource[]{resource}, this.tags[i], true).run((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IPreferenceStore preferenceStore = RelEngPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean("useDefaultMapProject") || preferenceStore.getString("defaultMapProject").length() <= 0) {
            MapProjectSelectionWizard wizard = new MapProjectSelectionWizard(Messages.getString("ReplaceLocalFromMap.0"));
            wizard.execute(this.getShell());
            if (wizard.operationCancelled()) {
                return;
            }
        }
        final IResource[][] resources = new IResource[1][];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(null, 100);
                        resources[0] = ReplaceLocalFromMap.this.checkOverwriteOfDirtyResources(ReplaceLocalFromMap.this.getSelectedResources(), (IProgressMonitor)new InfiniteSubProgressMonitor(monitor, 100));
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 2);
        if (resources[0] == null || resources[0].length == 0) {
            return;
        }
        CVSTagHelper tagHelper = new CVSTagHelper();
        this.tags = tagHelper.findMissingMapEntries(resources[0]);
        boolean operationCancelled = tagHelper.warnAboutUnfoundMapEntries(Messages.getString("ReplaceLocalFromMap.1"));
        if (operationCancelled || this.tags == null) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ReplaceLocalFromMap.this.performReplace(resources[0], monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
    }
}

