/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.releng.tools.OrderedMap;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;

public class MapEntry {
    private static final String HEAD = "HEAD";
    private static final String KEY_TAG = "tag";
    private static final String KEY_PATH = "path";
    private static final String KEY_CVSROOT = "cvsRoot";
    private static final String KEY_PASSWORD = "password";
    private static final String EMPTY_STRING = "";
    private boolean valid = false;
    private String type = "";
    private String id = "";
    private OrderedMap arguments = new OrderedMap();
    private boolean legacy = false;
    private String version;

    public static void main(String[] args) {
        String[] strings = new String[]{EMPTY_STRING, " ", "type", "type@", "type@id", "type@id=", "type@id=tag,", "type@id=tag, connectString", "type@id=tag, connectString,", "type@id=tag, connectString,password", "type@id=tag, connectString,password,", "type@id=tag, connectString,password,moduleName", "type@id=tag, connectString,,moduleName", "!***************  FEATURE CONTRIBUTION  ******************************************************", "@", "=", ",,,", "@=,,,,", "type@id,version=CVS,tag=myTag,cvsRoot=myCvsRoot,password=password,path=myPath"};
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            MapEntry anEntry = new MapEntry(string);
            System.out.println("-----------------------------------------------");
            System.out.println("input: " + string);
            System.out.println("map string: " + anEntry.getMapString());
            anEntry.display();
            ++i;
        }
    }

    private void display() {
        System.out.println("Is Valid: " + this.isValid());
        System.out.println("Type: " + this.getType());
        System.out.println("Project Name: " + this.getId());
        System.out.println("Tag: " + this.getTagName());
        if (this.version != null) {
            System.out.println("Version: " + this.version);
        }
        System.out.println("Connect: " + this.getRepo());
        System.out.println("Password: " + this.getPassword());
        System.out.println("CVS Module: " + this.getCVSModule());
    }

    public MapEntry(String entryLine) {
        this.init(entryLine);
    }

    private void init(String entryLine) {
        this.valid = false;
        if (entryLine.startsWith("#") || entryLine.startsWith("!")) {
            return;
        }
        int start = 0;
        int end = entryLine.indexOf(64);
        if (end == -1) {
            return;
        }
        this.type = entryLine.substring(start, end).trim();
        start = end + 1;
        if ((end = entryLine.indexOf(61, start)) == -1) {
            return;
        }
        this.id = entryLine.substring(start, end).trim();
        int comma = this.id.indexOf(44);
        if (comma != -1) {
            this.version = this.id.substring(comma + 1);
            this.id = this.id.substring(0, comma);
        }
        String[] args = MapEntry.getArrayFromStringWithBlank(entryLine.substring(end + 1), ",");
        this.arguments = this.populate(args);
        String tag = (String)this.arguments.get(KEY_TAG);
        String repo = (String)this.arguments.get(KEY_CVSROOT);
        if (tag == null || tag.length() == 0 || repo == null || repo.length() == 0) {
            return;
        }
        this.valid = true;
    }

    private OrderedMap populate(String[] entries) {
        OrderedMap result = new OrderedMap();
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            int index = entry.indexOf(61);
            if (index == -1) {
                if (i != 0 || !"CVS".equalsIgnoreCase(entry)) {
                    return this.legacyPopulate(entries);
                }
            } else {
                String key = entry.substring(0, index);
                String value = entry.substring(index + 1);
                result.put(key, value);
            }
            ++i;
        }
        result.toString();
        return result;
    }

    private OrderedMap legacyPopulate(String[] entries) {
        this.legacy = true;
        OrderedMap result = new OrderedMap();
        if (entries.length >= 2) {
            result.put(KEY_TAG, entries[0]);
            result.put(KEY_CVSROOT, entries[1]);
            if (entries.length >= 3) {
                result.put(KEY_PASSWORD, entries[2]);
            }
            if (entries.length >= 4) {
                result.put(KEY_PATH, entries[3]);
            }
        }
        return result;
    }

    public static String[] getArrayFromStringWithBlank(String list, String separator) {
        if (list == null || list.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean previousWasSeparator = true;
        StringTokenizer tokens = new StringTokenizer(list, separator, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals(separator)) {
                if (previousWasSeparator) {
                    result.add(EMPTY_STRING);
                }
                previousWasSeparator = true;
                continue;
            }
            result.add(token);
            previousWasSeparator = false;
        }
        return result.toArray(new String[result.size()]);
    }

    public String getTagName() {
        String value = (String)this.arguments.get(KEY_TAG);
        return value == null || HEAD.equals(value) ? EMPTY_STRING : value;
    }

    public CVSTag getTag() {
        if (this.getTagName().equals(HEAD) || this.getTagName().equals(EMPTY_STRING)) {
            return CVSTag.DEFAULT;
        }
        return new CVSTag(this.getTagName(), 2);
    }

    public String getPassword() {
        String value = (String)this.arguments.get(KEY_PASSWORD);
        return value == null ? EMPTY_STRING : value;
    }

    public String getId() {
        return this.id;
    }

    private String internalGetCVSModule() {
        String module = (String)this.arguments.get(KEY_PATH);
        return module == null ? this.id : module;
    }

    public String getCVSModule() {
        String value = (String)this.arguments.get(KEY_PATH);
        return value == null ? EMPTY_STRING : value;
    }

    public String getRepo() {
        String value = (String)this.arguments.get(KEY_CVSROOT);
        return value == null ? EMPTY_STRING : value;
    }

    public String getType() {
        return this.type;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getReferenceString() {
        if (!this.isValid()) {
            return null;
        }
        String projectName = new Path(this.internalGetCVSModule()).lastSegment();
        return "1.0," + this.getRepo() + "," + this.internalGetCVSModule() + "," + projectName + "," + this.getTagName();
    }

    public String getMapString() {
        StringBuffer result = new StringBuffer();
        if (this.legacy) {
            result.append(this.getType());
            result.append('@');
            result.append(this.getId());
            if (this.version != null) {
                result.append(',');
                result.append(this.version);
            }
            result.append('=');
            result.append(this.getTagName());
            result.append(',');
            result.append(this.getRepo());
            result.append(',');
            result.append(this.getPassword());
            if (!this.getCVSModule().equals(EMPTY_STRING) || !this.getPassword().equals(EMPTY_STRING)) {
                result.append(',');
            }
            result.append(this.getCVSModule());
            return result.toString();
        }
        result.append(this.getType());
        result.append('@');
        result.append(this.getId());
        if (this.version != null) {
            result.append(',');
            result.append(this.version);
        }
        result.append('=');
        result.append("CVS");
        Iterator iter = this.arguments.keys().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.arguments.get(key);
            if (value == null || value.length() <= 0) continue;
            result.append(String.valueOf(',') + key + '=' + value);
        }
        return result.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setPassword(String password) {
        this.arguments.put(KEY_PASSWORD, password);
    }

    public void setId(String projectID) {
        this.id = projectID;
    }

    public void setCVSModule(String path) {
        this.arguments.put(KEY_PATH, path);
    }

    public void setRepo(String repo) {
        this.arguments.put(KEY_CVSROOT, repo);
    }

    public void setTagName(String tagName) {
        this.arguments.put(KEY_TAG, tagName);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String toString() {
        return "Entry: " + this.getMapString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapEntry) {
            return ((MapEntry)obj).getMapString().equals(this.getMapString());
        }
        return super.equals(obj);
    }

    public boolean isMappedTo(String moduleName) {
        Path entryPath = new Path(this.internalGetCVSModule());
        Path modulePath = new Path(moduleName);
        if (entryPath.segmentCount() != modulePath.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < entryPath.segmentCount()) {
            if (!entryPath.segment(i).equals(modulePath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isMappedTo(IProject project) {
        String moduleName;
        block3: {
            try {
                moduleName = this.getCVSModule(project);
                if (moduleName != null) break block3;
                return false;
            }
            catch (CVSException e) {
                RelEngPlugin.getDefault().getLog().log(e.getStatus());
                return false;
            }
        }
        return this.isMappedTo(moduleName);
    }

    private String getCVSModule(IProject project) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        FolderSyncInfo info = folder.getFolderSyncInfo();
        if (info == null) {
            return null;
        }
        return info.getRepository();
    }
}

