/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class BlockComment {
    int start;
    int end;
    private String contents;
    private static String newLine = System.getProperty("line.separator");
    private String copyrightHolder;
    private List nonIBMContributors = new ArrayList();
    private String commentEnd;

    public BlockComment(int commentStartLine, int commentEndLine, String comment, String commentStartString, String commentEndString) {
        this.start = commentStartLine;
        this.end = commentEndLine;
        this.commentEnd = commentEndString;
        this.contents = comment;
    }

    public String getContents() {
        return this.contents;
    }

    public boolean isCopyright() {
        return this.contents.toLowerCase().indexOf("copyright") != -1;
    }

    public boolean atTop() {
        return this.start == 0;
    }

    public boolean notIBM() {
        String lowercaseCopyrightHolder;
        int result;
        String lowerCaseContents = this.contents.toLowerCase();
        if (this.copyrightHolder == null) {
            int start = lowerCaseContents.indexOf("copyright");
            if (start == -1) {
                return false;
            }
            int end = lowerCaseContents.indexOf(newLine, start);
            this.copyrightHolder = this.contents.substring(start + "copyright".length(), end);
        }
        if ((result = (lowercaseCopyrightHolder = this.copyrightHolder.toLowerCase()).indexOf("ibm")) != -1) {
            return false;
        }
        result = lowercaseCopyrightHolder.indexOf("international business machine");
        return result == -1;
    }

    public String getCopyrightHolder() {
        return this.copyrightHolder;
    }

    public List nonIBMContributors() {
        String lowerCaseContents = this.contents.toLowerCase();
        int start = lowerCaseContents.indexOf("contributors");
        if (start == -1) {
            return this.nonIBMContributors;
        }
        if ((start = lowerCaseContents.indexOf(newLine, start)) == -1) {
            return this.nonIBMContributors;
        }
        BufferedReader aReader = new BufferedReader(new StringReader(lowerCaseContents.substring(start += newLine.length())));
        try {
            String aLine = aReader.readLine();
            while (aLine != null) {
                if ((aLine = aLine.trim()).length() > 0 && aLine.indexOf(this.commentEnd) == -1 && aLine.indexOf("ibm") == -1 && aLine.indexOf("international business machine") == -1) {
                    this.nonIBMContributors.add(aLine);
                }
                aLine = aReader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.nonIBMContributors;
    }
}

