/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.releng.tools.BlockComment;
import org.eclipse.releng.tools.CopyrightComment;
import org.eclipse.releng.tools.RelEngPlugin;

public class AdvancedCopyrightComment
extends CopyrightComment {
    private static final String DATE_VAR = "${date}";
    private static final String NEW_LINE = "\n";
    private String preYearComment = null;
    private String postYearComment = null;

    private AdvancedCopyrightComment(int commentStyle, int creationYear, int revisionYear, List contributors, String preYearComment, String postYearComment) {
        super(commentStyle, creationYear == -1 ? AdvancedCopyrightComment.getPreferenceStore().getInt("org.eclipse.releng.tools.creationYear") : creationYear, revisionYear);
        this.preYearComment = preYearComment;
        this.postYearComment = postYearComment;
    }

    private AdvancedCopyrightComment(int commentStyle, int creationYear, int revisionYear, List contributors) {
        this(commentStyle, creationYear, revisionYear, contributors, null, null);
    }

    public static AdvancedCopyrightComment defaultComment(int commentStyle) {
        return new AdvancedCopyrightComment(commentStyle, -1, -1, null);
    }

    private static IPreferenceStore getPreferenceStore() {
        return RelEngPlugin.getDefault().getPreferenceStore();
    }

    private static String[] getLegalLines() {
        StringTokenizer st = new StringTokenizer(AdvancedCopyrightComment.getPreferenceStore().getString("org.eclipse.releng.tools.copyrightTemplate"), NEW_LINE, true);
        ArrayList<String> lines = new ArrayList<String>();
        String previous = NEW_LINE;
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            if (NEW_LINE.equals(previous)) {
                lines.add(current);
            }
            previous = current;
        }
        String[] stringLines = new String[lines.size()];
        stringLines = lines.toArray(stringLines);
        return stringLines;
    }

    public String getCopyrightComment() {
        if (this.preYearComment != null || this.postYearComment != null) {
            String copyrightString = this.preYearComment == null ? "" : this.preYearComment;
            copyrightString = String.valueOf(copyrightString) + this.getCreationYear();
            if (this.hasRevisionYear() && this.getRevisionYear() != this.getCreationYear()) {
                copyrightString = String.valueOf(copyrightString) + ", " + this.getRevisionYear();
            }
            String endString = this.postYearComment == null ? "" : this.postYearComment;
            copyrightString = String.valueOf(copyrightString) + endString;
            return copyrightString;
        }
        String linePrefix = this.getCommentPrefix();
        if (linePrefix == null) {
            return null;
        }
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        try {
            this.writeCommentStart(writer);
            this.writeLegal(writer, linePrefix);
            this.writeCommentEnd(writer);
            String string = out.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    private void writeLegal(PrintWriter writer, String linePrefix) {
        String[] legalLines = AdvancedCopyrightComment.getLegalLines();
        int i = 0;
        while (i < legalLines.length) {
            String currentLine = legalLines[i];
            int offset = currentLine.indexOf(DATE_VAR);
            if (offset > -1) {
                writer.print(String.valueOf(linePrefix) + ' ' + currentLine.substring(0, offset) + this.getCreationYear());
                if (this.hasRevisionYear() && this.getRevisionYear() != this.getCreationYear()) {
                    writer.print(", " + this.getRevisionYear());
                }
                this.println(writer, currentLine.substring(offset + DATE_VAR.length(), currentLine.length()));
            } else if (NEW_LINE.equals(currentLine)) {
                this.println(writer, linePrefix);
            } else {
                this.println(writer, String.valueOf(linePrefix) + ' ' + currentLine);
            }
            ++i;
        }
    }

    public static AdvancedCopyrightComment parse(BlockComment comment, int commentStyle) {
        AdvancedCopyrightComment copyright = null;
        if (comment == null) {
            copyright = AdvancedCopyrightComment.defaultComment(commentStyle);
        } else {
            String body = comment.getContents();
            String[] legalLines = AdvancedCopyrightComment.getLegalLines();
            int i = 0;
            int yearOffset = -1;
            while (i < legalLines.length && yearOffset == -1) {
                String line = legalLines[i];
                yearOffset = line.indexOf(DATE_VAR);
                ++i;
            }
            if (yearOffset != -1) {
                String yearLine = legalLines[i - 1];
                String preYear = yearLine.substring(0, yearOffset);
                int preYearOffset = body.toLowerCase().indexOf(preYear.toLowerCase());
                if (preYearOffset != -1) {
                    int preYearEnd = preYearOffset + preYear.length();
                    Pattern yearsPattern = Pattern.compile("\\s*(\\d+)(?:\\s*[,-]\\s*(\\d+))?");
                    Matcher yearsMatcher = yearsPattern.matcher(body.substring(preYearEnd));
                    if (yearsMatcher.find()) {
                        int startYear = -1;
                        try {
                            startYear = Integer.parseInt(yearsMatcher.group(1));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        int endYear = -1;
                        String endYearString = yearsMatcher.group(2);
                        if (endYearString != null) {
                            try {
                                endYear = Integer.parseInt(endYearString);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        String pre = body.substring(0, preYearEnd);
                        String post = body.substring(preYearEnd + yearsMatcher.group().length());
                        copyright = new AdvancedCopyrightComment(commentStyle, startYear, endYear, null, pre, post);
                    }
                }
            }
        }
        return copyright;
    }
}

