/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.providers.MarkerProviderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerListenerUtils {
    public static ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? new ValidateAction.EclipseResourcesUtil() : null;
    private static final Map<String, String> MARKER_LABELS = new HashMap<String, String>();
    private static final Map<String, Set<String>> MARKER_HIERARCHY = new HashMap<String, Set<String>>();

    static {
        MarkerListenerUtils.loadMarkerTypes();
    }

    public static EObject eObjectFromMarkerOrMap(IMarker marker, Map attributes, EditingDomain domain) {
        if (domain == null || domain.getResourceSet() == null) {
            return null;
        }
        String uriAttribute = marker != null ? marker.getAttribute("uri", null) : (String)attributes.get("uri");
        if (uriAttribute != null) {
            URI uriOfMarker = URI.createURI((String)uriAttribute);
            try {
                return domain.getResourceSet().getEObject(uriOfMarker, false);
            }
            catch (MissingResourceException e) {
                return MarkerListenerUtils.eObjectOfFragment(uriOfMarker, domain);
            }
            catch (WrappedException e) {
                return MarkerListenerUtils.eObjectOfFragment(uriOfMarker, domain);
            }
        }
        return null;
    }

    public static EObject eObjectOfFragment(URI uri, EditingDomain domain) {
        try {
            for (Resource resource : domain.getResourceSet().getResources()) {
                EObject eObjectOfMarker;
                if (uri.fragment() == null || (eObjectOfMarker = resource.getEObject(uri.fragment())) == null) continue;
                return eObjectOfMarker;
            }
        }
        catch (WrappedException wrappedException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static IMarkerProvider getMarkerProvider(Resource resource) {
        return MarkerProviderRegistry.INSTANCE.getMarkerProvider(resource);
    }

    public static List<IMarkerProvider> getMarkerProviders(Resource resource) {
        return MarkerProviderRegistry.INSTANCE.getMarkerProviders(resource);
    }

    public static IFile getFile(Resource resource) {
        IFile result;
        URI uri = resource.getURI();
        ResourceSet rset = resource.getResourceSet();
        if (rset != null) {
            uri = rset.getURIConverter().normalize(uri);
        }
        IFile iFile = result = uri.isPlatformResource() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))) : null;
        if (result != null && !result.exists()) {
            result = null;
        }
        return result;
    }

    public static String getMarkerTypeLabel(String type) {
        String result = MARKER_LABELS.get(type);
        if (result == null) {
            result = type;
        }
        return result;
    }

    private static void loadMarkerTypes() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension next = iExtensionArray[n2];
            String type = next.getUniqueIdentifier();
            MARKER_LABELS.put(type, next.getLabel());
            HashSet<String> superTypes = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = next.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String super_;
                IConfigurationElement config = iConfigurationElementArray[n4];
                if ("super".equals(config.getName()) && (super_ = config.getAttribute("type")) != null && super_.length() > 0) {
                    superTypes.add(super_);
                }
                ++n4;
            }
            MARKER_HIERARCHY.put(type, Collections.unmodifiableSet(superTypes));
            ++n2;
        }
    }

    public static boolean isMarkerTypeSubtypeOf(String subtype, String supertype) {
        boolean result = false;
        Set<String> supertypes = MARKER_HIERARCHY.get(subtype);
        if (supertypes != null && !(result = supertypes.contains(supertype))) {
            HashSet<String> cycleDetect = new HashSet<String>();
            cycleDetect.add(subtype);
            result = MarkerListenerUtils.isAnyMarkerTypeSubtypeOf(supertypes, supertype, cycleDetect);
        }
        return result;
    }

    private static boolean isAnyMarkerTypeSubtypeOf(Set<String> subtypes, String supertype, Set<String> cycleDetect) {
        boolean result = false;
        for (String subtype : subtypes) {
            Set<String> supertypes;
            if (!cycleDetect.add(subtype) || (supertypes = MARKER_HIERARCHY.get(subtype)) == null) continue;
            result = supertypes.contains(supertype);
            if (!result) {
                result = MarkerListenerUtils.isAnyMarkerTypeSubtypeOf(supertypes, supertype, cycleDetect);
            }
            if (result) break;
        }
        return result;
    }
}

