/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelExplorerHandler
extends AbstractHandler {
    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return editingDomain;
    }

    protected IPageManager getPageManager() {
        IPageManager pageManager = null;
        try {
            pageManager = ServiceUtilsForActionHandlers.getInstance().getIPageManager();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pageManager;
    }

    private <T> T adapt(Object object, Class<T> expectedClassType) {
        EObject eobject = EMFHelper.getEObject((Object)object);
        if (eobject != null && expectedClassType.isInstance(eobject)) {
            return (T)eobject;
        }
        Object ele = Platform.getAdapterManager().getAdapter(object, expectedClassType);
        if (ele != null) {
            return (T)ele;
        }
        if (EObject.class.isAssignableFrom(expectedClassType) && (eobject = (EObject)Platform.getAdapterManager().getAdapter(object, EObject.class)) != null && expectedClassType.isInstance(eobject)) {
            return (T)eobject;
        }
        return null;
    }

    private <T> List<T> getAllElementAdaptedToType(List<Object> list, Class<T> expectedClassType) {
        ArrayList<T> res = new ArrayList<T>();
        for (Object cur : list) {
            T adapted = this.adapt(cur, expectedClassType);
            if (adapted == null) continue;
            res.add(adapted);
        }
        return res;
    }

    protected <T> List<T> getCurrentSelectionAdaptedToType(ExecutionEvent event, Class<T> expectedType) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return this.getAllElementAdaptedToType(structuredSelection.toList(), expectedType);
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return this.getAllElementAdaptedToType(treeSelection.toList(), expectedType);
        }
        return null;
    }
}

