/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IFolder;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPanelPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ErrorComponentPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPanelParent;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ImageToolTipManager;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PTabFolder;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabItemPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.AbstractTabFolderPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFolderPart
extends AbstractTabFolderPart
implements IFolder {
    Logger log = Logger.getLogger(this.getClass().getName());
    protected ITabFolderModel partModel;
    private Object rawModel;
    protected PTabFolder pTabFolder;
    protected TabPartList currentTabItems = new TabPartList();
    private DropTarget dropTarget;
    private MouseHoverTracker mouseHoverTracker;
    IDragOverListener dragOverListener = new IDragOverListener(){

        public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
            return null;
        }
    };
    private PTabFolder.IPTabFolderListener cTabFolderEventListener = new PTabFolder.IPTabFolderListener(){

        public void contextMenuDetectEvent(CTabItem tab, Event event) {
        }

        public void itemClosedEvent(CTabFolderEvent event, int pageIndex) {
            TabFolderPart.this.getContentProvider().removePage(TabFolderPart.this.partModel, pageIndex);
        }

        public void menuDetectEvent(CTabItem tab, MenuDetectEvent event) {
        }

        public void pageChangeEvent(int newPageIndex) {
            TabFolderPart.this.pageChange(newPageIndex);
        }

        public void mouseDoubleClickEvent(int itemIndex, MouseEvent e) {
            PagePart page = TabFolderPart.this.getPagePart(itemIndex);
            TabFolderPart.this.getSashWindowContainer().getFolderTabMouseEventProvider().fireMouseDoubleClickEvent(page, TabFolderPart.this, e);
        }

        public void mouseUpEvent(int itemIndex, MouseEvent e) {
            PagePart page = TabFolderPart.this.getPagePart(itemIndex);
            TabFolderPart.this.getSashWindowContainer().getFolderTabMouseEventProvider().fireMouseUpEvent(page, TabFolderPart.this, e);
        }

        public void mouseDownEvent(int itemIndex, MouseEvent e) {
            PagePart page = TabFolderPart.this.getPagePart(itemIndex);
            TabFolderPart.this.getSashWindowContainer().getFolderTabMouseEventProvider().fireMouseDownEvent(page, TabFolderPart.this, e);
        }
    };

    public TabFolderPart(IPanelParent parent, ITabFolderModel partModel, Object rawModel) {
        super(parent);
        this.partModel = partModel;
        this.rawModel = rawModel;
    }

    protected ITabFolderModel getPartModel() {
        return this.partModel;
    }

    private void activate() {
        this.pTabFolder.getEventManager().addListener(this.cTabFolderEventListener);
        this.mouseHoverTracker = new MouseHoverTracker((Control)this.pTabFolder.getControl(), new ImageToolTipManager());
    }

    private void deactivate() {
        this.pTabFolder.getEventManager().removeListener(this.cTabFolderEventListener);
        this.mouseHoverTracker.deactivate();
    }

    @Override
    public void fillPartMap(PartLists partMap) {
        partMap.addPart(this);
        this.garbageState = AbstractPart.GarbageState.UNVISITED;
        for (TabItemPart child : this.currentTabItems) {
            child.fillPartMap(partMap);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        this.createControl(parent);
        this.activate();
    }

    public void createControl(Composite parent) {
        PTabFolder res;
        this.pTabFolder = res = new PTabFolder();
        res.createPartControl(parent);
        this.initDrag(res.getControl());
        this.initMenuManager();
        this.getSashWindowContainer().getFolderLifeCycleEventProvider().fireFolderCreatedEvent(this);
    }

    private void initMenuManager() {
        MenuManager menuManager = this.getSashWindowContainer().getFolderTabMenuManager();
        if (menuManager != null) {
            this.setFolderTabMenuManager(menuManager);
        }
    }

    public void setFolderTabMenuManager(MenuManager menuManager) {
        Composite folderControl = this.getControl();
        Menu menu = menuManager.createContextMenu((Control)folderControl);
        folderControl.setMenu(menu);
    }

    @Override
    protected void pageChange(int newPageIndex) {
        if (newPageIndex < 0 || newPageIndex > this.currentTabItems.size() - 1) {
            return;
        }
        this.getSashWindowContainer().setActivePage(((TabItemPart)this.currentTabItems.get((int)newPageIndex)).childPart);
    }

    protected void setSelection(int pageIndex) {
        if (!this.isValidPageIndex(pageIndex)) {
            return;
        }
        this.getTabFolder().setSelection(pageIndex);
    }

    public final void setSelection(PagePart requestedPage) {
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            PagePart page = this.getPagePart(i);
            if (page == requestedPage) {
                this.setSelection(i);
                break;
            }
            ++i;
        }
    }

    @Override
    public void dispose() {
        this.getControl().setMenu(null);
        this.getSashWindowContainer().getFolderLifeCycleEventProvider().fireFolderDisposedEvent(this);
        this.deactivate();
        this.pTabFolder.dispose();
    }

    @Override
    public void disposeThisAndChildren() {
        for (TabItemPart child : this.currentTabItems) {
            if (child == null) continue;
            child.disposeThisAndChildren();
        }
        this.partModel = null;
        this.rawModel = null;
        this.currentTabItems.clear();
        this.currentTabItems = null;
        this.dragOverListener = null;
    }

    private void initDrag(Composite container) {
        DragUtil.addDragTarget((Control)container, (IDragOverListener)this.dragOverListener);
    }

    @Override
    protected CTabFolder getTabFolder() {
        return this.pTabFolder.getTabFolder();
    }

    @Override
    public Composite getControl() {
        return this.getTabFolder();
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        this.getPagePart(pageIndex).setFocus();
    }

    @Override
    public AbstractPart findPart(Point toFind) {
        return this;
    }

    @Override
    public AbstractPart findPartAt(Point toFind, Class<?> expectedTileType) {
        if (expectedTileType == this.getClass()) {
            return this;
        }
        TabItemPart activeTabPart = this.getActiveTab();
        if (activeTabPart == null) {
            return null;
        }
        return this.getActiveTab().findPartAt(toFind, expectedTileType);
    }

    private TabItemPart getActiveTab() {
        int index = this.getActivePage();
        if (index != -1) {
            return (TabItemPart)this.currentTabItems.get(index);
        }
        return null;
    }

    protected PagePart getPagePart(int index) {
        if (index < 0) {
            return null;
        }
        return ((TabItemPart)this.currentTabItems.get(index)).getChildPart();
    }

    protected TabItemPart lookupAssociatedTabItemPart(PagePart page) {
        for (TabItemPart child : this.currentTabItems) {
            if (child.getChildPart() != page) continue;
            return child;
        }
        return null;
    }

    public PagePart getVisiblePagePart() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getPagePart(index);
        }
        return null;
    }

    @Override
    public AbstractPanelPart findPart(Object control) {
        if (this.getControl() == control) {
            return this;
        }
        if (control instanceof CTabItem && ((CTabItem)control).getParent() == this.getControl()) {
            return this;
        }
        return null;
    }

    @Override
    public IDropTarget getDropTarget(Object draggedObject, TabFolderPart sourcePart, Point position) {
        CTabItem tabUnderPointer = this.pTabFolder.getItem(position);
        int sourceIndex = PTabFolder.getDraggedObjectTabIndex(draggedObject);
        if (tabUnderPointer == null) {
            Rectangle titleArea = this.pTabFolder.getTabArea();
            if (titleArea.contains(position) && this.pTabFolder.getTabFolder().getItemCount() > 0) {
                int dragOverIndex = this.pTabFolder.getTabFolder().getItemCount();
                CTabItem lastTab = this.pTabFolder.getTabFolder().getItem(dragOverIndex - 1);
                if (!lastTab.isShowing()) {
                    return null;
                }
                Rectangle lastTabBounds = lastTab.getBounds();
                if (lastTabBounds.isEmpty()) {
                    return null;
                }
                Rectangle dropRectangle = titleArea;
                dropRectangle.x = dropRectangle.x + lastTabBounds.x + lastTabBounds.width;
                dropRectangle.width = 3 * dropRectangle.height;
                return this.createDropTarget(sourcePart, sourceIndex, dropRectangle, dragOverIndex);
            }
            Rectangle displayBounds = DragUtil.getDisplayBounds((Control)this.pTabFolder.getControl());
            int closestSide = Geometry.getClosestSide((Rectangle)displayBounds, (Point)position);
            if (closestSide == this.pTabFolder.getTabFolder().getTabPosition()) {
                return this.createDropTarget(sourcePart, sourceIndex, displayBounds, -1);
            }
            return null;
        }
        if (!tabUnderPointer.isShowing()) {
            return null;
        }
        Rectangle tabBounds = this.pTabFolder.getItemBounds(tabUnderPointer);
        if (tabBounds.isEmpty()) {
            return null;
        }
        return this.createDropTarget(sourcePart, sourceIndex, tabBounds, this.pTabFolder.getTabFolder().indexOf(tabUnderPointer));
    }

    public IDropTarget createDropTarget(TabFolderPart sourcePart, int sourceIndex, Rectangle snapRectangle, int tabIndex) {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(sourcePart, sourceIndex, snapRectangle, tabIndex);
            return this.dropTarget;
        }
        this.dropTarget.setTarget(sourcePart, sourceIndex, snapRectangle, tabIndex);
        return this.dropTarget;
    }

    @Override
    public void orphan() {
        if (this.garbageState == AbstractPart.GarbageState.UNVISITED) {
            this.garbageState = AbstractPart.GarbageState.ORPHANED;
            this.parent = null;
        }
    }

    @Override
    public AbstractPart.GarbageState getGarbageState() {
        return this.garbageState;
    }

    @Override
    public void reparent(IPanelParent newParent, Composite swtParent) {
        this.parent = newParent;
        assert (this.getControl() != null);
        this.getControl().setParent(swtParent);
        this.garbageState = AbstractPart.GarbageState.REPARENTED;
    }

    @Override
    public boolean isPartFor(Object realModel) {
        return this.getRawModel() == realModel;
    }

    @Override
    public Object getRawModel() {
        return this.rawModel;
    }

    public void refreshPageTab(PagePart page) {
        TabItemPart itemPart = this.currentTabItems.getByPagePart(page);
        if (itemPart == null) {
            return;
        }
        itemPart.refreshTabDecorations();
    }

    @Override
    public void synchronize2(PartLists partLists) {
        List<?> newModels = this.partModel.getChildren();
        CTabFolder folder = this.getTabFolder();
        folder.setRedraw(false);
        int activePageIndex = this.getActivePage();
        int minSize = Math.min(newModels.size(), this.currentTabItems.size());
        int index = 0;
        while (index < minSize) {
            Object curModel = newModels.get(index);
            TabItemPart curTab = (TabItemPart)this.currentTabItems.get(index);
            if (!curTab.isTabItemFor(curModel)) {
                this.resetTabItem(curTab, partLists, curModel);
                activePageIndex = index;
            } else {
                curTab.getChildPart().unchanged();
            }
            ++index;
        }
        if (index < newModels.size()) {
            int i = index;
            while (i < newModels.size()) {
                Object curModel = newModels.get(i);
                this.createTabItem(partLists, curModel, i);
                ++i;
            }
            activePageIndex = newModels.size() - 1;
        } else if (index < this.currentTabItems.size()) {
            ArrayList<TabItemPart> toRemove = new ArrayList<TabItemPart>();
            int i = index;
            while (i < this.currentTabItems.size()) {
                TabItemPart curTab = (TabItemPart)this.currentTabItems.get(i);
                toRemove.add(curTab);
                ++i;
            }
            for (TabItemPart curTab : toRemove) {
                this.removeTabItem(curTab);
            }
            if (activePageIndex >= this.currentTabItems.size()) {
                activePageIndex = this.currentTabItems.size() - 1;
            }
        }
        folder.setRedraw(true);
        folder.redraw();
        if (activePageIndex >= 0) {
            folder.getItem(activePageIndex).getControl().setVisible(true);
            this.setSelection(activePageIndex);
        } else if (this.getTabFolder().getItemCount() > 0 && this.getTabFolder().getSelectionIndex() < 0) {
            this.setSelection(0);
        }
    }

    private void removeTabItem(TabItemPart tabItem) {
        this.currentTabItems.remove(tabItem);
        tabItem.remove();
    }

    private void createTabItem(PartLists existingParts, Object newModel, int index) {
        TabItemPart newTab = null;
        PagePart modelPart = existingParts.findPagePartFor(newModel);
        if (modelPart != null) {
            modelPart.reparent(this);
            newTab = new TabItemPart(this, modelPart, index);
        } else {
            modelPart = this.createChildPart(newModel);
            if (modelPart != null) {
                existingParts.addCreatedPage(modelPart);
                newTab = new TabItemPart(this, modelPart, index);
            }
        }
        if (newTab != null) {
            this.currentTabItems.add(index, newTab);
        }
    }

    private void resetTabItem(TabItemPart tabItem, PartLists existingParts, Object newModel) {
        PagePart modelPart = existingParts.findPagePartFor(newModel);
        if (modelPart != null) {
            tabItem.resetChild(modelPart);
        } else {
            modelPart = this.createChildPart(newModel);
            existingParts.addCreatedPage(modelPart);
            tabItem.resetChild(modelPart);
        }
    }

    private PagePart createChildPart(Object newModel) {
        final IPageModel partModel = this.getPartModel().createChildSashModel(newModel);
        if (partModel != null) {
            PagePart newPart = this.getSashWindowContainer().createPagePart(this, partModel, newModel);
            this.getSashWindowContainer().getLifeCycleEventProvider().firePageAboutToBeOpenedEvent(newPart);
            newPart.createPartControl(this.getControl());
            this.getSashWindowContainer().getLifeCycleEventProvider().firePageOpenedEvent(newPart);
            if (newPart.getControl() != null) {
                newPart.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        partModel.dispose();
                    }
                });
            } else {
                partModel.dispose();
            }
            return newPart;
        }
        return this.createErrorPage();
    }

    private PagePart createErrorPage() {
        Activator.log.warn("Error: the SashWindowContainer returned an invalid tab");
        return new ErrorComponentPart(this);
    }

    private void showTabs(String msg) {
        CTabItem item;
        System.out.println("------- " + msg);
        CTabFolder folder = this.getTabFolder();
        CTabItem[] items = folder.getItems();
        System.out.printf("sel.index %2d :\n", folder.getSelectionIndex());
        System.out.printf("items %2d :", folder.getItemCount());
        CTabItem[] cTabItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            System.out.printf("%10s |", item.getControl());
            ++n2;
        }
        System.out.println();
        System.out.printf("it.dispose:", new Object[0]);
        cTabItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            System.out.printf("%10b |", item.getControl().isDisposed());
            ++n2;
        }
        System.out.println();
        System.out.printf("it.ctrl.vis:", new Object[0]);
        cTabItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            System.out.printf("%10s |", item.getControl().isVisible());
            ++n2;
        }
        System.out.println();
        System.out.printf("it.ctrl   :", new Object[0]);
        cTabItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            System.out.printf("%10s |", item.getControl());
            ++n2;
        }
        System.out.println();
        System.out.printf("tabs %2d :", this.currentTabItems.size());
        for (TabItemPart tab : this.currentTabItems) {
            System.out.printf("%10s |", tab);
        }
        System.out.println();
    }

    protected void showStatus() {
        CTabFolder ctrl = this.getTabFolder();
        System.out.printf("tabfolder[%2d]: disposed=%-5b, visible=%-5b, garbState=%-10s, %s\n", new Object[]{this.currentTabItems.size(), ctrl.isDisposed(), ctrl.isDisposed() ? false : this.getTabFolder().isVisible(), this.garbageState, this});
    }

    @Override
    public boolean visit(IPartVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean visitChildren(IPartVisitor visitor) {
        for (TabItemPart child : this.currentTabItems) {
            if (child.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    protected class DropTarget
    implements IDropTarget {
        int cursor = 0x1000000;
        private TabFolderPart sourcePart;
        private Rectangle snapRectangle;
        private int targetIndex;
        private int sourceIndex;

        public DropTarget(TabFolderPart sourcePart, int sourceIndex, Rectangle snapRectangle, int targetIndex) {
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
            this.sourcePart = sourcePart;
            this.snapRectangle = snapRectangle;
        }

        public void setTarget(TabFolderPart sourcePart, int sourceIndex, Rectangle snapRectangle, int targetIndex) {
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
            this.sourcePart = sourcePart;
            this.snapRectangle = snapRectangle;
        }

        public void drop() {
            if (this.sourcePart == TabFolderPart.this) {
                TabFolderPart.this.getContentProvider().movePage(this.sourcePart.getPartModel(), this.sourceIndex, this.targetIndex);
            } else {
                TabFolderPart.this.getContentProvider().movePage(this.sourcePart.getPartModel(), this.sourceIndex, TabFolderPart.this.getPartModel(), this.targetIndex);
            }
        }

        public Cursor getCursor() {
            return DragCursors.getCursor((int)DragCursors.positionToDragCursor((int)this.cursor));
        }

        public Rectangle getSnapRectangle() {
            return this.snapRectangle;
        }
    }

    public class MouseHoverTracker {
        private Control control;
        private ImageToolTipManager toolTipManager;
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){
            private int count = 0;

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                MouseHoverTracker.this.toolTipManager.closeToolTip();
            }

            public void mouseHover(MouseEvent e) {
                CTabFolder folder = TabFolderPart.this.getTabFolder();
                Point pt = new Point(e.x, e.y);
                CTabItem item = folder.getItem(pt);
                int index = ((MouseHoverTracker)MouseHoverTracker.this).TabFolderPart.this.pTabFolder.getItemIndex(pt);
                if (index == -1) {
                    MouseHoverTracker.this.toolTipManager.closeToolTip();
                    return;
                }
                PagePart part = ((TabItemPart)((MouseHoverTracker)MouseHoverTracker.this).TabFolderPart.this.currentTabItems.get(index)).getChildPart();
                MouseHoverTracker.this.toolTipManager.showToolTip(part, item.getBounds(), pt);
            }
        };
        private Listener mouseClickedListener = new Listener(){
            private int count = 0;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 4: {
                        MouseHoverTracker.this.toolTipManager.disableToolTip();
                    }
                }
            }
        };

        public MouseHoverTracker(Control control, ImageToolTipManager toolTipManager) {
            this.control = control;
            this.toolTipManager = toolTipManager;
            this.activate();
        }

        public void activate() {
            this.control.addMouseTrackListener(this.mouseTrackListener);
            this.control.addListener(4, this.mouseClickedListener);
        }

        public void deactivate() {
            this.control.removeMouseTrackListener(this.mouseTrackListener);
            this.control.removeListener(4, this.mouseClickedListener);
            this.toolTipManager.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TabPartList
    extends ArrayList<TabItemPart> {
        public boolean containsModel(Object model) {
            return this.indexOfModel(model) >= 0;
        }

        public int indexOfModel(Object o) {
            if (o == null) {
                int i = 0;
                while (i < this.size()) {
                    if (this.get(i) == null) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.size()) {
                    if (o.equals(((TabItemPart)this.get(i)).getChildPart().getRawModel())) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        public TabItemPart getByModel(Object model) {
            return (TabItemPart)this.get(this.indexOfModel(model));
        }

        public TabItemPart getByPagePart(PagePart page) {
            return (TabItemPart)this.get(this.indexOfModel(page.getRawModel()));
        }
    }
}

