/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.markup;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.utilities.HTMLBuffer;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.xtext.markup.BulletElement;
import org.eclipse.ocl.examples.xtext.markup.CompoundElement;
import org.eclipse.ocl.examples.xtext.markup.FigureElement;
import org.eclipse.ocl.examples.xtext.markup.FigureRefElement;
import org.eclipse.ocl.examples.xtext.markup.FontElement;
import org.eclipse.ocl.examples.xtext.markup.FootnoteElement;
import org.eclipse.ocl.examples.xtext.markup.HeadingElement;
import org.eclipse.ocl.examples.xtext.markup.MarkupElement;
import org.eclipse.ocl.examples.xtext.markup.MarkupToString;
import org.eclipse.ocl.examples.xtext.markup.MarkupUtils;
import org.eclipse.ocl.examples.xtext.markup.NewLineElement;
import org.eclipse.ocl.examples.xtext.markup.NullElement;
import org.eclipse.ocl.examples.xtext.markup.OCLCodeElement;
import org.eclipse.ocl.examples.xtext.markup.OCLEvalElement;
import org.eclipse.ocl.examples.xtext.markup.OCLTextElement;
import org.eclipse.ocl.examples.xtext.markup.TextElement;
import org.eclipse.ocl.examples.xtext.markup.util.MarkupSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupToHTML
extends MarkupSwitch<HTMLBuffer> {
    @Nullable
    private OCL ocl = null;
    @NonNull
    private MetaModelManager metaModelManager;
    @Nullable
    protected final Object context;
    @NonNull
    protected final HTMLBuffer s = new HTMLBuffer();

    public static String toString(@NonNull MetaModelManager metaModelManager, @Nullable Object context, @NonNull MarkupElement element) throws Exception {
        MarkupToHTML toString = new MarkupToHTML(metaModelManager, context);
        try {
            return ((HTMLBuffer)toString.doSwitch(element)).toString();
        }
        catch (InvalidMarkupException e) {
            throw (Exception)e.getCause();
        }
    }

    public MarkupToHTML(@NonNull MetaModelManager metaModelManager, @Nullable Object context) {
        this.metaModelManager = metaModelManager;
        this.context = context;
    }

    @Override
    public HTMLBuffer caseBulletElement(BulletElement object) {
        Integer level = Integer.valueOf(object.getLevel());
        this.s.startBulletLevel(level);
        this.caseCompoundElement(object);
        this.s.endBulletLevel(level);
        return this.s;
    }

    @Override
    public HTMLBuffer caseCompoundElement(CompoundElement object) {
        for (MarkupElement element : object.getElements()) {
            this.doSwitch(element);
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseFigureElement(FigureElement object) {
        if (object.getDef() != null) {
            this.s.appendLabelDef(object.getDef());
        }
        this.s.appendFigure(object.getSrc(), object.getAlt(), object.getRequiredWidth(), object.getRequiredHeight());
        return this.s;
    }

    @Override
    public HTMLBuffer caseFigureRefElement(FigureRefElement object) {
        FigureElement ref = object.getRef();
        if (ref.eIsProxy()) {
            String message = "Unresolved proxy '" + ((InternalEObject)ref).eProxyURI() + "'";
            throw new InvalidMarkupException(new IllegalStateException(message));
        }
        this.s.appendLabelRef(ref.getDef());
        return this.s;
    }

    @Override
    public HTMLBuffer caseFontElement(FontElement object) {
        String font = object.getFont();
        String htmlFont = "b".equals(font) ? "b" : ("e".equals(font) ? "i" : "???");
        this.s.startFontName(htmlFont);
        this.caseCompoundElement(object);
        this.s.endFontName(htmlFont);
        return this.s;
    }

    @Override
    public HTMLBuffer caseFootnoteElement(FootnoteElement object) {
        this.s.startFootnote();
        this.caseCompoundElement(object);
        this.s.endFootnote();
        return this.s;
    }

    @Override
    public HTMLBuffer caseHeadingElement(HeadingElement object) {
        String level = object.getLevel();
        if (level == null) {
            level = "1";
        }
        this.s.startHeadingLevel(level);
        this.caseCompoundElement(object);
        this.s.endHeadingLevel(level);
        return this.s;
    }

    @Override
    public HTMLBuffer caseNewLineElement(NewLineElement object) {
        assert (object != null);
        int newLines = MarkupUtils.getNewlineCount(object);
        if (newLines <= 1) {
            this.s.append("\n");
        } else {
            this.s.append("\n");
            this.s.endParagraph();
            this.s.startParagraph();
            this.s.append("\n");
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseNullElement(NullElement object) {
        this.s.append('[');
        this.caseCompoundElement(object);
        this.s.append(']');
        return this.s;
    }

    @Override
    public HTMLBuffer caseOCLCodeElement(OCLCodeElement object) {
        this.s.startFontName("pre");
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        String oclString = MarkupToString.toString(elements);
        try {
            try {
                ExpressionInOCL query = this.createQuery(oclString);
                String text = PrettyPrinter.print((Element)query);
                this.s.append(text);
            }
            catch (ParserException e) {
                throw new InvalidMarkupException((Exception)((Object)e));
            }
        }
        finally {
            this.s.endFontName("pre");
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseOCLEvalElement(OCLEvalElement object) {
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        String oclString = MarkupToString.toString(elements);
        try {
            OCL ocl = this.getOCL();
            ExpressionInOCL query = this.createQuery(oclString);
            Object value = ocl.evaluate(this.context, query);
            this.s.append(String.valueOf(value));
        }
        catch (ParserException e) {
            throw new InvalidMarkupException((Exception)((Object)e));
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseOCLTextElement(OCLTextElement object) {
        this.s.startFontName("tt");
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        String oclString = MarkupToString.toString(elements);
        try {
            try {
                ExpressionInOCL query = this.createQuery(oclString);
                PrettyPrintOptions.Global options = PrettyPrinter.createOptions(null);
                options.setLinelength(Integer.MAX_VALUE);
                String text = PrettyPrinter.print((Element)query, (PrettyPrintOptions)options);
                this.s.append(text);
            }
            catch (ParserException e) {
                throw new InvalidMarkupException((Exception)((Object)e));
            }
        }
        finally {
            this.s.endFontName("tt");
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseTextElement(TextElement object) {
        for (String text : object.getText()) {
            int iMax = text.length();
            if (iMax <= 0) continue;
            char c = text.charAt(0);
            if (c == ' ' || c == '\t') {
                this.s.append(' ');
                continue;
            }
            int i = 0;
            while (i < iMax) {
                if ((c = text.charAt(i++)) == '\\' && i < iMax) {
                    c = text.charAt(i++);
                }
                this.s.append(c);
            }
        }
        return this.s;
    }

    @NonNull
    protected ExpressionInOCL createQuery(@NonNull String oclString) throws ParserException {
        OCL ocl = this.getOCL();
        OCLHelper helper = ocl.createOCLHelper();
        if (this.context instanceof EObject) {
            Resource resource;
            EClass eClass = ((EObject)this.context).eClass();
            String name = eClass.getName();
            assert (name != null);
            Type pivotType = this.metaModelManager.getPivotType(name);
            if (pivotType == null && (resource = eClass.eResource()) != null) {
                Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter((Resource)resource, (MetaModelManager)this.metaModelManager);
                pivotType = (Type)ecore2Pivot.getCreated(Type.class, (EObject)eClass);
            }
            if (pivotType != null) {
                helper.setContext(pivotType);
            }
        }
        return helper.createQuery(oclString);
    }

    @Override
    public HTMLBuffer defaultCase(EObject object) {
        this.s.append("<Unsupported ");
        this.s.append(object.eClass().getName());
        this.s.append(">");
        return this.s;
    }

    @NonNull
    protected OCL getOCL() {
        OCL ocl2 = this.ocl;
        if (ocl2 == null) {
            EPackage.Registry packageRegistry = null;
            PivotEnvironmentFactory envFactory = new PivotEnvironmentFactory(packageRegistry, this.metaModelManager);
            ocl2 = this.ocl = OCL.newInstance((EnvironmentFactory)envFactory);
        }
        return ocl2;
    }

    public String toString() {
        return this.s.toString();
    }

    public static class InvalidMarkupException
    extends RuntimeException {
        public InvalidMarkupException(Exception e) {
            super(e);
        }
    }
}

