/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.validation;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateValidator;
import org.eclipse.ocl.examples.pivot.uml.UMLOCLEValidator;
import org.eclipse.papyrus.infra.services.validation.EValidatorAdapter;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLEValidatorAdapter
extends EValidatorAdapter {
    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject.eIsProxy()) {
            if (context != null && context.get("org.eclipse.emf.ecore.EObject_NoCircularContainment") != null && diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.uml2.uml", 4, "_UI_UnresolvedProxy_diagnostic", new Object[]{OCLEValidatorAdapter.getFeatureLabel((EStructuralFeature)eObject.eContainmentFeature(), context), OCLEValidatorAdapter.getObjectLabel((EObject)eObject.eContainer(), context), OCLEValidatorAdapter.getObjectLabel((EObject)eObject, context)}, new Object[]{eObject.eContainer(), eObject.eContainmentFeature(), eObject}, context));
            }
        } else if (eClass.eContainer() == this.getEPackage()) {
            this.validate(eClass.getClassifierID(), eObject, diagnostics, context);
        } else {
            new OCLDelegateValidator((EObjectValidator)this){}.validate(eClass, eObject, diagnostics, context);
        }
        return this.batchValidate(eObject, diagnostics, context);
    }

    public boolean validateInstanceSpecification(InstanceSpecification instanceSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!super.validateInstanceSpecification(instanceSpecification, diagnostics, context)) {
            return false;
        }
        return UMLOCLEValidator.INSTANCE.validateInstanceSpecification(instanceSpecification, diagnostics, context);
    }

    public boolean validateOpaqueAction(OpaqueAction opaqueAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!super.validateOpaqueAction(opaqueAction, diagnostics, context)) {
            return false;
        }
        return UMLOCLEValidator.INSTANCE.validateOpaqueAction(opaqueAction, diagnostics, context);
    }

    public boolean validateOpaqueBehavior(OpaqueBehavior opaqueBehavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!super.validateOpaqueBehavior(opaqueBehavior, diagnostics, context)) {
            return false;
        }
        return UMLOCLEValidator.INSTANCE.validateOpaqueBehavior(opaqueBehavior, diagnostics, context);
    }

    public boolean validateOpaqueExpression(OpaqueExpression opaqueExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!super.validateOpaqueExpression(opaqueExpression, diagnostics, context)) {
            return false;
        }
        return UMLOCLEValidator.INSTANCE.validateOpaqueExpression(opaqueExpression, diagnostics, context);
    }
}

