/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.internal.helper.task.CreateDNodeTask;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationVariable;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class NodeCreationCommandBuilder
extends AbstractDiagramCommandBuilder {
    protected final NodeCreationDescription tool;
    protected DDiagramElement diagramElement;
    protected DDiagram diagram;
    private final boolean createInDiagram;

    public NodeCreationCommandBuilder(NodeCreationDescription tool, DDiagramElement diagramElement) {
        this.tool = tool;
        this.diagramElement = diagramElement;
        this.diagram = diagramElement != null ? diagramElement.getParentDiagram() : null;
        this.createInDiagram = false;
    }

    public NodeCreationCommandBuilder(NodeCreationDescription tool, DDiagram diagram) {
        this.tool = tool;
        this.diagram = diagram;
        this.createInDiagram = true;
    }

    public Command buildCommand() {
        if (this.createInDiagram) {
            return this.buildInDiagramCommand();
        }
        return this.buildInDiagramElementCommand();
    }

    private Command buildInDiagramElementCommand() {
        if (this.canCreateNodeInTarget() && this.checkPrecondition(this.diagramElement, (AbstractToolDescription)this.tool)) {
            DCommand result = this.buildCreateNodeCommandFromTool(this.diagramElement.getTarget(), (EObject)this.diagramElement);
            result.getTasks().add(this.buildCreateNodeTask(result));
            this.addRefreshTask(this.diagramElement, result, (AbstractToolDescription)this.tool);
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command buildInDiagramCommand() {
        if (this.permissionAuthority.canEditInstance((EObject)this.diagram)) {
            EObject model = null;
            if (this.diagram instanceof DSemanticDiagram) {
                model = ((DSemanticDiagram)this.diagram).getTarget();
            }
            if (model != null && this.checkPrecondition(this.diagram, (AbstractToolDescription)this.tool)) {
                DCommand result = this.buildCreateNodeCommandFromTool(model, this.diagram);
                result.getTasks().add(new CreateDNodeTask(this.tool, result, this.modelAccessor, this.diagram));
                this.addRefreshTask(this.diagram, result, (AbstractToolDescription)this.tool);
                return result;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected DCommand buildCreateNodeCommandFromTool(EObject semanticContainer, EObject container) {
        DCommand result = this.createEnclosingCommand();
        if (this.canCreateNodeInTarget()) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semanticContainer);
            HashMap<NodeCreationVariable, EObject> variables = new HashMap<NodeCreationVariable, EObject>();
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            variables.put(this.tool.getVariable(), semanticContainer);
            variables.put((NodeCreationVariable)this.tool.getViewVariable(), container);
            this.addDiagramVariable(result, container, interpreter);
            if (this.tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)this.diagram, semanticContainer, this.tool.getInitialOperation().getFirstModelOperations()));
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    private boolean canCreateNodeInTarget() {
        boolean nodeCanBeCreateInTarget = false;
        if (this.diagramElement != null) {
            nodeCanBeCreateInTarget = this.permissionAuthority.canEditInstance((EObject)this.diagramElement) && this.diagramElement.getTarget() != null && !this.diagramElement.getTarget().eIsProxy();
        } else if (this.diagram != null && (nodeCanBeCreateInTarget = this.permissionAuthority.canEditInstance((EObject)this.diagram)) && this.diagram instanceof DSemanticDecorator) {
            nodeCanBeCreateInTarget = ((DSemanticDecorator)this.diagram).getTarget() != null && !((DSemanticDecorator)this.diagram).getTarget().eIsProxy();
        }
        return nodeCanBeCreateInTarget;
    }

    private ICommandTask buildCreateNodeTask(DCommand createdObjects) {
        CreateDNodeTask task = null;
        if (this.diagramElement instanceof DNode) {
            task = new CreateDNodeTask(this.tool, createdObjects, this.modelAccessor, (DNode)this.diagramElement);
        } else if (this.diagramElement instanceof DDiagramElementContainer) {
            task = new CreateDNodeTask(this.tool, createdObjects, this.modelAccessor, (DDiagramElementContainer)this.diagramElement);
        }
        return task;
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return Options.newSome((Object)this.diagram);
    }
}

