/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.label.InitInterpreterFromParsedVariableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DLabelled;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class DirectEditCommandBuilder
extends AbstractDiagramCommandBuilder {
    private static final String EDIT_LABEL = "Edit label";
    private DLabelled labeled;
    private DirectEditLabel directEditTool;
    private String newValue;

    public DirectEditCommandBuilder(DLabelled labeled, DirectEditLabel directEditTool, String newValue) {
        this.labeled = labeled;
        this.directEditTool = directEditTool;
        this.newValue = newValue;
    }

    public Command buildCommand() {
        if (this.permissionAuthority.canEditInstance((EObject)this.labeled) && !this.isInLayoutingModeDiagram((EObject)this.labeled)) {
            DCommand result = this.createEnclosingCommand();
            String messageFormat = "$0";
            if (this.directEditTool.getMask() != null) {
                messageFormat = this.directEditTool.getMask().getMask();
            }
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.labeled);
            result.getTasks().add(new InitInterpreterFromParsedVariableTask(interpreter, messageFormat, this.newValue));
            Option<DDiagram> parentDiagram = this.getDDiagram();
            if (parentDiagram.some() && this.labeled instanceof DSemanticDecorator && ((DSemanticDecorator)this.labeled).getTarget() != null && this.directEditTool.getInitialOperation() != null) {
                ICommandTask operations = this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), ((DSemanticDecorator)this.labeled).getTarget(), this.directEditTool.getInitialOperation().getFirstModelOperations());
                result.getTasks().add(operations);
            }
            this.addPostOperationTasks(result, interpreter);
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected void addPostOperationTasks(DCommand command, IInterpreter interpreter) {
        if (this.labeled instanceof DDiagramElement) {
            this.addRefreshTask((DDiagramElement)this.labeled, command, (AbstractToolDescription)this.directEditTool);
        }
    }

    protected String getEnclosingCommandLabel() {
        return EDIT_LABEL;
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return new EObjectQuery((EObject)this.labeled).getParentDiagram();
    }
}

