/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilter;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class RefreshSiriusElement
extends RecordingCommand {
    private DRefreshable uniqueRefreshable;
    private Collection<?> refreshablesList;
    private Collection<RefreshFilter> filters;

    public RefreshSiriusElement(TransactionalEditingDomain domain, DRefreshable objectToRefresh) {
        super(domain, "Refresh representation");
        this.uniqueRefreshable = objectToRefresh;
    }

    public RefreshSiriusElement(TransactionalEditingDomain domain, Collection<?> objectsToRefresh, Collection<RefreshFilter> filters) {
        super(domain, "Refresh representation");
        this.refreshablesList = objectsToRefresh;
        this.filters = filters;
    }

    protected void doExecute() {
        if (this.uniqueRefreshable != null) {
            this.uniqueRefreshable.refresh();
            this.enableVisibilityUpdate(this.uniqueRefreshable);
            this.forceVisibilityRefresh(this.uniqueRefreshable);
        }
        if (this.refreshablesList != null) {
            for (Object obj : this.refreshablesList) {
                if (obj instanceof DRepresentation) {
                    if (this.isFiltered((DRepresentation)obj)) continue;
                    ((DRepresentation)obj).refresh();
                    this.enableVisibilityUpdate((DRefreshable)obj);
                    this.forceVisibilityRefresh((DRefreshable)obj);
                    continue;
                }
                if (!(obj instanceof DRefreshable)) continue;
                ((DRefreshable)obj).refresh();
                this.enableVisibilityUpdate((DRefreshable)obj);
                this.forceVisibilityRefresh((DRefreshable)obj);
            }
        }
    }

    private void forceVisibilityRefresh(DRefreshable obj) {
        if (obj instanceof DDiagram) {
            DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)obj);
        } else if (obj instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)obj;
            DDiagram parentDiagram = dde.getParentDiagram();
            Session session = SessionManager.INSTANCE.getSession(dde.getTarget());
            NotificationUtil.sendNotification((EObject)parentDiagram, (int)0, (int)2);
            DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, parentDiagram);
            DisplayServiceManager.INSTANCE.getDisplayService().computeVisibility(mappingManager, parentDiagram, dde);
            NotificationUtil.sendNotification((EObject)parentDiagram, (int)1, (int)2);
        }
    }

    private boolean isFiltered(DRepresentation vp) {
        if (this.filters != null) {
            for (RefreshFilter filter : this.filters) {
                if (filter.shouldRefresh(vp)) continue;
                return true;
            }
        }
        return false;
    }

    private void enableVisibilityUpdate(DRefreshable obj) {
        DDiagram diagram = null;
        if (obj instanceof DDiagramElement) {
            diagram = ((DDiagramElement)obj).getParentDiagram();
        } else if (obj instanceof DDiagram) {
            diagram = (DDiagram)obj;
        }
        if (diagram != null) {
            NotificationUtil.sendNotification((EObject)diagram, (int)0, (int)5);
        }
    }
}

