/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.description.ConditionalContainerStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalEdgeStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalNodeStyleDescription;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.diagram.description.util.DescriptionSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;

public class GetConditionalStyle
extends DescriptionSwitch<List<? extends ConditionalStyleDescription>> {
    private static final EList<ConditionalStyleDescription> EMPTY = new BasicEList();
    private DDiagram dDiagram;

    public GetConditionalStyle(DDiagram dDiagram) {
        this.dDiagram = dDiagram;
    }

    @Override
    public EList<? extends ConditionalStyleDescription> caseNodeMapping(NodeMapping object) {
        return object.getConditionnalStyles();
    }

    @Override
    public EList<? extends ConditionalStyleDescription> caseEdgeMapping(EdgeMapping object) {
        BasicEList result = new BasicEList(object.getConditionnalStyles());
        result.addAll(this.getConditionalStyleOfImportedMapping(object));
        return result;
    }

    @Override
    public EList<? extends ConditionalStyleDescription> caseEdgeMappingImport(EdgeMappingImport object) {
        BasicEList result = new BasicEList(object.getConditionnalStyles());
        result.addAll(this.getConditionalStyleOfImportedMapping(object));
        return result;
    }

    private Collection<? extends ConditionalEdgeStyleDescription> getConditionalStyleOfImportedMapping(EdgeMapping object) {
        BasicEList result = new BasicEList();
        if (object instanceof EdgeMappingImport) {
            result.addAll(this.getConditionalStyleOfImportedMapping((EdgeMappingImport)((Object)object)));
        } else if (object instanceof EdgeMappingImportWrapper) {
            result.addAll(this.getConditionalStyleOfImportedMapping(((EdgeMappingImportWrapper)object).getWrappedEdgeMappingImport()));
        }
        return result;
    }

    private Collection<? extends ConditionalEdgeStyleDescription> getConditionalStyleOfImportedMapping(EdgeMappingImport object) {
        Option<EdgeMapping> edgeMapping;
        BasicEList result = new BasicEList();
        if (this.dDiagram != null && (edgeMapping = new IEdgeMappingQuery(object.getImportedMapping()).getEdgeMapping()).some()) {
            result.addAll(((EdgeMapping)edgeMapping.get()).getConditionnalStyles());
        }
        if (object.getImportedMapping() instanceof EdgeMappingImport) {
            result.addAll(this.getConditionalStyleOfImportedMapping((EdgeMappingImport)object.getImportedMapping()));
        }
        return result;
    }

    @Override
    public List<? extends ConditionalStyleDescription> caseContainerMappingImport(ContainerMappingImport object) {
        ArrayList result = Lists.newArrayList();
        result.addAll(object.getConditionnalStyles());
        if (object.getImportedMapping() != null) {
            List importedContionalStyles = (List)this.doSwitch(object.getImportedMapping());
            Iterables.addAll((Collection)result, (Iterable)Iterables.filter((Iterable)importedContionalStyles, ConditionalContainerStyleDescription.class));
        }
        return result;
    }

    @Override
    public List<? extends ConditionalStyleDescription> caseNodeMappingImport(NodeMappingImport object) {
        ArrayList result = Lists.newArrayList();
        result.addAll(object.getConditionnalStyles());
        if (object.getImportedMapping() != null) {
            List importedContionalStyles = (List)this.doSwitch(object.getImportedMapping());
            Iterables.addAll((Collection)result, (Iterable)Iterables.filter((Iterable)importedContionalStyles, ConditionalNodeStyleDescription.class));
        }
        return result;
    }

    @Override
    public EList<? extends ConditionalStyleDescription> caseContainerMapping(ContainerMapping object) {
        return object.getConditionnalStyles();
    }

    @Override
    public EList<? extends ConditionalStyleDescription> defaultCase(EObject object) {
        SiriusPlugin.getDefault().error("Impossible to get the conditional style descriptions for object : " + object, (Throwable)new RuntimeException());
        return EMPTY;
    }
}

