/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.componentization.mappings.table;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionMappingManagerQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.table.CandidateMapping;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;

public class CandidateMappingManager {
    private Set<DiagramElementMapping> allMappings;
    private Set<CandidateMapping> availableCandidates;
    private Predicate<CandidateMapping> nodeMappingPredicate = new Predicate<CandidateMapping>(){

        public boolean apply(CandidateMapping input) {
            return input.getMapping() instanceof NodeMapping;
        }
    };
    private Predicate<CandidateMapping> containerMappingPredicate = new Predicate<CandidateMapping>(){

        public boolean apply(CandidateMapping input) {
            return input.getMapping() instanceof ContainerMapping;
        }
    };
    private Predicate<CandidateMapping> edgeMappingPredicate = new Predicate<CandidateMapping>(){

        public boolean apply(CandidateMapping input) {
            return input.getMapping() instanceof EdgeMapping;
        }
    };
    private DiagramDescriptionMappingsManager mappingsManager;

    public CandidateMappingManager(DiagramDescriptionMappingsManager mappingsManager) {
        this.mappingsManager = mappingsManager;
    }

    public void build(final Collection<Layer> activatedLayers) {
        this.computeAllMappings();
        this.sortMappings();
        this.convertMappingsToCandidate();
        Predicate<CandidateMapping> availablePredicate = new Predicate<CandidateMapping>(){

            public boolean apply(CandidateMapping input) {
                Collection<Layer> layers = input.getParentLayers();
                for (Layer layer : layers) {
                    if (!EqualityHelper.contains((Collection)activatedLayers, (EObject)layer)) continue;
                    return true;
                }
                return false;
            }
        };
        this.availableCandidates = Sets.filter(this.availableCandidates, (Predicate)availablePredicate);
    }

    private void computeAllMappings() {
        this.allMappings = new DiagramDescriptionMappingManagerQuery(this.mappingsManager).computeAllMappings();
    }

    private void sortMappings() {
        ArrayList<DiagramElementMapping> sortedMappings = new ArrayList<DiagramElementMapping>(this.allMappings);
        Collections.sort(sortedMappings, new Comparator<DiagramElementMapping>(){

            @Override
            public int compare(DiagramElementMapping mapping1, DiagramElementMapping mapping2) {
                if (mapping1 instanceof AbstractNodeMapping && mapping2 instanceof AbstractNodeMapping) {
                    return this.compareAM((AbstractNodeMapping)mapping1, (AbstractNodeMapping)mapping2);
                }
                if (mapping1 instanceof EdgeMapping && mapping2 instanceof EdgeMapping) {
                    return this.compareEM((EdgeMapping)mapping1, (EdgeMapping)mapping2);
                }
                return 0;
            }

            private int compareAM(AbstractNodeMapping nodeMapping1, AbstractNodeMapping nodeMapping2) {
                if (nodeMapping1 instanceof AbstractMappingImport && CandidateMappingManager.getImportedMapping((AbstractMappingImport)nodeMapping1) == nodeMapping2) {
                    return 1;
                }
                if (nodeMapping2 instanceof AbstractMappingImport && CandidateMappingManager.getImportedMapping((AbstractMappingImport)nodeMapping2) == nodeMapping1) {
                    return -1;
                }
                return 0;
            }

            private int compareEM(EdgeMapping edgeMapping1, EdgeMapping edgeMapping2) {
                IEdgeMappingQuery query;
                Option<EdgeMapping> importedMapping;
                if (edgeMapping1 instanceof EdgeMappingImport && (importedMapping = (query = new IEdgeMappingQuery(((EdgeMappingImport)((Object)edgeMapping1)).getImportedMapping())).getEdgeMapping()).some() && importedMapping.get() == edgeMapping2) {
                    return 1;
                }
                if (edgeMapping2 instanceof EdgeMappingImport && (importedMapping = (query = new IEdgeMappingQuery(((EdgeMappingImport)((Object)edgeMapping2)).getImportedMapping())).getEdgeMapping()).some() && importedMapping.get() == edgeMapping1) {
                    return -1;
                }
                return 0;
            }
        });
        this.allMappings = new LinkedHashSet<DiagramElementMapping>(sortedMappings);
    }

    public static AbstractNodeMapping getImportedMapping(AbstractMappingImport mappingImport) {
        DragAndDropTargetDescription importedMapping = null;
        if (mappingImport instanceof NodeMappingImport) {
            importedMapping = ((NodeMappingImport)mappingImport).getImportedMapping();
        } else if (mappingImport instanceof ContainerMappingImport) {
            importedMapping = ((ContainerMappingImport)mappingImport).getImportedMapping();
        }
        return importedMapping;
    }

    private void convertMappingsToCandidate() {
        this.availableCandidates = new LinkedHashSet<CandidateMapping>();
        for (DiagramElementMapping mapping : this.allMappings) {
            CandidateMapping candidate = new CandidateMapping(mapping);
            this.availableCandidates.add(candidate);
        }
    }

    public Collection<CandidateMapping> getAvailableCandidateNodeMappings() {
        return ImmutableSet.copyOf((Collection)Collections2.filter(this.availableCandidates, this.nodeMappingPredicate));
    }

    public Collection<CandidateMapping> getAvailableCandidateContainerMappings() {
        return ImmutableSet.copyOf((Collection)Collections2.filter(this.availableCandidates, this.containerMappingPredicate));
    }

    public Collection<CandidateMapping> getAvailableCandidateEdgeMappings() {
        return ImmutableSet.copyOf((Collection)Collections2.filter(this.availableCandidates, this.edgeMappingPredicate));
    }
}

