/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AppliedCompositeFilters;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.FoldingFilter;
import org.eclipse.sirius.diagram.FoldingPointFilter;
import org.eclipse.sirius.diagram.HideFilter;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.diagram.IndirectlyCollapseFilter;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DEdgeQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.util.DiagramSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.style.LabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class DDiagramElementQuery {
    private DDiagramElement element;

    public DDiagramElementQuery(DDiagramElement dDiagramElement) {
        this.element = dDiagramElement;
    }

    public Option<? extends RepresentationElementMapping> getMapping() {
        ActualMappingGetter mappingGetter = new ActualMappingGetter();
        return (Option)mappingGetter.doSwitch((EObject)this.element);
    }

    public Option<String> getMappingName() {
        String result = null;
        Option<? extends RepresentationElementMapping> mapping = this.getMapping();
        if (mapping != null && mapping.some()) {
            result = ((RepresentationElementMapping)mapping.get()).getName();
        }
        return Options.newSome(result);
    }

    public boolean isHidden() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(HideFilter.class));
    }

    public boolean isCustomized() {
        DDiagramElementContainer dDiagramElementContainer;
        boolean isCustomized = false;
        if (this.element instanceof DEdge) {
            isCustomized = new DEdgeQuery((DEdge)this.element).isCustomized();
        } else if (this.element instanceof DNode) {
            DNode dNode = (DNode)this.element;
            if (dNode.getOwnedStyle() != null) {
                isCustomized = !dNode.getOwnedStyle().getCustomFeatures().isEmpty();
            }
        } else if (this.element instanceof DDiagramElementContainer && (dDiagramElementContainer = (DDiagramElementContainer)this.element).getOwnedStyle() != null) {
            isCustomized = !dDiagramElementContainer.getOwnedStyle().getCustomFeatures().isEmpty();
        }
        return isCustomized;
    }

    public boolean isLabelHidden() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(HideLabelFilter.class));
    }

    public boolean canHideLabel() {
        return !this.isLabelEmpty() && (this.element instanceof DNode && LabelPosition.BORDER_LITERAL.equals((Object)((DNode)this.element).getOwnedStyle().getLabelPosition()) || this.element instanceof DEdge);
    }

    private boolean isLabelEmpty() {
        boolean result = true;
        DiagramElementMapping mapping = this.element.getDiagramElementMapping();
        if (mapping == null) {
            return result;
        }
        Style style = this.element.getStyle();
        if (style != null) {
            StyleDescription styleDescription = style.getDescription();
            if (styleDescription instanceof LabelStyleDescription) {
                String labelExpression = ((LabelStyleDescription)styleDescription).getLabelExpression();
                result = StringUtil.isEmpty((String)labelExpression);
            } else if (styleDescription instanceof EdgeStyleDescription && this.element instanceof DEdge) {
                result = !new DEdgeQuery((DEdge)this.element).hasNonEmptyNameDefinition();
            }
        }
        return result;
    }

    public boolean isIndirectlyHidden() {
        if (this.isHidden()) {
            return true;
        }
        boolean isHidden = false;
        if (this.element.eContainer() instanceof DDiagramElement) {
            isHidden = new DDiagramElementQuery((DDiagramElement)this.element.eContainer()).isIndirectlyHidden();
        } else if (this.element instanceof DEdge) {
            DEdge edge = (DEdge)this.element;
            if (edge.getSourceNode() instanceof DDiagramElement) {
                boolean bl = isHidden = isHidden || new DDiagramElementQuery((DDiagramElement)((Object)edge.getSourceNode())).isIndirectlyHidden();
            }
            if (edge.getTargetNode() instanceof DDiagramElement) {
                isHidden = isHidden || new DDiagramElementQuery((DDiagramElement)((Object)edge.getTargetNode())).isIndirectlyHidden();
            }
        }
        return isHidden;
    }

    public boolean isCollapsed() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(CollapseFilter.class), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(IndirectlyCollapseFilter.class))));
    }

    public boolean isIndirectlyCollapsed() {
        if (this.isCollapsed()) {
            return true;
        }
        return this.isOnlyIndirectlyCollapsed();
    }

    public boolean isOnlyIndirectlyCollapsed() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(IndirectlyCollapseFilter.class));
    }

    public boolean isFiltered() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(AppliedCompositeFilters.class));
    }

    public boolean isIndirectlyFiltered() {
        if (this.isFiltered()) {
            return true;
        }
        boolean isFiltered = false;
        if (this.element.eContainer() instanceof DDiagramElement) {
            isFiltered = new DDiagramElementQuery((DDiagramElement)this.element.eContainer()).isFiltered();
        } else if (this.element instanceof DEdge) {
            DEdge edge = (DEdge)this.element;
            if (edge.getSourceNode() instanceof DDiagramElement) {
                boolean bl = isFiltered = isFiltered || new DDiagramElementQuery((DDiagramElement)((Object)edge.getSourceNode())).isFiltered();
            }
            if (edge.getTargetNode() instanceof DDiagramElement) {
                isFiltered = isFiltered || new DDiagramElementQuery((DDiagramElement)((Object)edge.getTargetNode())).isFiltered();
            }
        }
        return isFiltered;
    }

    public Option<AppliedCompositeFilters> getAppliedCompositeFilters() {
        Iterable appliedFilters = Iterables.filter(this.element.getGraphicalFilters(), AppliedCompositeFilters.class);
        if (Iterables.isEmpty((Iterable)appliedFilters)) {
            return Options.newNone();
        }
        return Options.newSome((Object)((AppliedCompositeFilters)Iterables.get((Iterable)appliedFilters, (int)0)));
    }

    public Option<BasicLabelStyle> getLabelStyle() {
        Object labelStyle = null;
        if (this.element instanceof DEdge) {
            labelStyle = ((DEdge)this.element).getOwnedStyle().getCenterLabelStyle();
        } else if (this.element instanceof DNode) {
            labelStyle = ((DNode)this.element).getOwnedStyle();
        } else if (this.element instanceof DDiagramElementContainer) {
            labelStyle = ((DDiagramElementContainer)this.element).getOwnedStyle();
        }
        return Options.newSome((Object)labelStyle);
    }

    public boolean isLabelVisibleByDefault() {
        boolean result = true;
        if (this.element.getStyle() instanceof NodeStyle) {
            result = !((NodeStyle)this.element.getStyle()).isHideLabelByDefault();
        }
        return result;
    }

    public boolean isExplicitlyFolded() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(FoldingPointFilter.class));
    }

    public boolean isIndirectlyFolded() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(FoldingFilter.class));
    }

    public boolean isFolded() {
        return Iterables.any(this.element.getGraphicalFilters(), (Predicate)Predicates.or((Predicate)Predicates.instanceOf(FoldingPointFilter.class), (Predicate)Predicates.instanceOf(FoldingFilter.class)));
    }

    private static class ActualMappingGetter
    extends DiagramSwitch<Option<? extends RepresentationElementMapping>> {
        private ActualMappingGetter() {
        }

        @Override
        public Option<? extends RepresentationElementMapping> defaultCase(EObject object) {
            return Options.newNone();
        }

        @Override
        public Option<? extends RepresentationElementMapping> caseDDiagramElementContainer(DDiagramElementContainer object) {
            return Options.newSome((Object)object.getActualMapping());
        }

        @Override
        public Option<? extends RepresentationElementMapping> caseDNode(DNode object) {
            return Options.newSome((Object)object.getActualMapping());
        }

        @Override
        public Option<? extends RepresentationElementMapping> caseDNodeListElement(DNodeListElement object) {
            return Options.newSome((Object)object.getActualMapping());
        }

        @Override
        public Option<? extends RepresentationElementMapping> caseDEdge(DEdge object) {
            return new IEdgeMappingQuery(object.getActualMapping()).getEdgeMapping();
        }
    }
}

