/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineStyle implements Enumerator
{
    SOLID_LITERAL(0, "solid", "solid"),
    DASH_LITERAL(1, "dash", "dash"),
    DOT_LITERAL(2, "dot", "dot"),
    DASH_DOT_LITERAL(3, "dash_dot", "dash_dot");

    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASH_DOT = 3;
    private static final LineStyle[] VALUES_ARRAY;
    public static final List<LineStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineStyle[]{SOLID_LITERAL, DASH_LITERAL, DOT_LITERAL, DASH_DOT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineStyle get(int value) {
        switch (value) {
            case 0: {
                return SOLID_LITERAL;
            }
            case 1: {
                return DASH_LITERAL;
            }
            case 2: {
                return DOT_LITERAL;
            }
            case 3: {
                return DASH_DOT_LITERAL;
            }
        }
        return null;
    }

    private LineStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

