/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.serializer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementWithURICS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.scoping.QualifiedPath;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.tokens.CrossReferenceSerializer;

public class EssentialOCLCrossReferenceSerializer
extends CrossReferenceSerializer {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverter;

    protected String getCrossReferenceNameFromScope(EObject semanticObject, CrossReference crossref, EObject target, IScope scope, ISerializationDiagnostic.Acceptor errors) {
        AcceptorHelper helper = new AcceptorHelper(semanticObject, crossref, target, scope, errors);
        boolean foundOne = false;
        String ruleName = this.linkingHelper.getRuleNameFrom((EObject)crossref);
        if ("URI".equals(ruleName)) {
            Object converted;
            PathElementWithURICS pathElementWithURICS;
            String uri;
            if (semanticObject instanceof PathElementWithURICS && (uri = (pathElementWithURICS = (PathElementWithURICS)semanticObject).getUri()) != null && (converted = helper.convert(uri, ruleName)) != null) {
                return converted;
            }
            Iterable elements = scope.getElements(target);
            for (IEObjectDescription desc : elements) {
                URI baseURI;
                URI uri2 = URI.createURI((String)desc.getName().toString());
                URI deresolvedURI = uri2.deresolve(baseURI = semanticObject.eResource().getURI(), true, true, false);
                String unconverted = deresolvedURI.toString();
                String converted2 = helper.convert(unconverted, ruleName);
                if (converted2 == null) continue;
                return converted2;
            }
        } else if (semanticObject instanceof PathElementCS) {
            PathElementCS pathElement = (PathElementCS)semanticObject;
            PathNameCS pathName = pathElement.getPathName();
            int index = pathName.getPath().indexOf((Object)pathElement);
            Element element = pathElement.getElement();
            if (element != null) {
                NamedElement namedElement = ElementUtil.isPathable((EObject)element);
                if (namedElement != null) {
                    String converted;
                    String name = namedElement.getName();
                    if (index == 0 && namedElement instanceof Package) {
                        Resource elementResource;
                        EObject root = EcoreUtil.getRootContainer((EObject)semanticObject);
                        Resource csResource = root.eResource();
                        Resource asResource = null;
                        if (root instanceof RootPackageCS) {
                            Element root2 = ((RootPackageCS)root).getPivot();
                            asResource = EcoreUtil.getRootContainer((EObject)root2).eResource();
                        }
                        if ((elementResource = namedElement.eResource()) != csResource && elementResource != asResource) {
                            String alias;
                            AliasAnalysis adapter;
                            AliasAnalysis aliasAnalysis = adapter = csResource != null ? AliasAnalysis.getAdapter((Resource)csResource) : null;
                            if (adapter != null && (alias = adapter.getAlias((EObject)namedElement, null)) != null) {
                                name = alias;
                            }
                        }
                    }
                    if ((converted = helper.convert(name, ruleName)) != null) {
                        return converted;
                    }
                } else {
                    URI baseURI;
                    EObject eTarget = element.getETarget();
                    URI uri = eTarget != null ? EcoreUtil.getURI((EObject)eTarget) : EcoreUtil.getURI((EObject)element);
                    URI deresolvedURI = uri.deresolve(baseURI = semanticObject.eResource().getURI(), true, true, false);
                    String unconverted = deresolvedURI.toString();
                    String converted = helper.convert(unconverted, ruleName);
                    if (converted != null) {
                        return converted;
                    }
                }
            }
        } else {
            Iterable elements = scope.getElements(target);
            for (IEObjectDescription desc : elements) {
                foundOne = true;
                QualifiedName name = desc.getName();
                List segments = name instanceof QualifiedPath ? ((QualifiedPath)name).getSegments(semanticObject) : name.getSegments();
                String converted = helper.convert(segments, ruleName);
                if (converted == null) continue;
                return converted;
            }
        }
        helper.report(foundOne);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AcceptorHelper {
        protected final EObject semanticObject;
        protected final CrossReference crossref;
        protected final EObject target;
        protected final IScope scope;
        @Nullable
        protected final ISerializationDiagnostic.Acceptor errors;
        @Nullable
        private List<ISerializationDiagnostic> recordedErrors = null;

        public AcceptorHelper(EObject semanticObject, CrossReference crossref, EObject target, @Nullable IScope scope, ISerializationDiagnostic.Acceptor errors) {
            this.semanticObject = semanticObject;
            this.crossref = crossref;
            this.target = target;
            this.scope = scope;
            this.errors = errors;
        }

        @Nullable
        public String convert(String unconverted, String ruleName) {
            try {
                return EssentialOCLCrossReferenceSerializer.this.valueConverter.toString((Object)unconverted, ruleName);
            }
            catch (ValueConverterException e) {
                this.record(unconverted, e);
                return null;
            }
        }

        @Nullable
        protected String convert(List<String> segments, String ruleName) {
            int iMax = segments.size();
            String[] converted = new String[iMax];
            String unconverted = null;
            try {
                int i = 0;
                while (i < iMax) {
                    unconverted = segments.get(i);
                    converted[i] = i > 0 && "UnrestrictedName".equals(ruleName) ? EssentialOCLCrossReferenceSerializer.this.valueConverter.toString((Object)unconverted, "UnreservedName") : EssentialOCLCrossReferenceSerializer.this.valueConverter.toString((Object)unconverted, ruleName);
                    ++i;
                }
                return EssentialOCLCrossReferenceSerializer.this.qualifiedNameConverter.toString(new QualifiedName(converted){});
            }
            catch (ValueConverterException e) {
                this.record(unconverted, e);
                return null;
            }
        }

        protected void record(String unconverted, @NonNull ValueConverterException e) {
            if (this.errors != null) {
                ArrayList recordedErrors2 = this.recordedErrors;
                if (recordedErrors2 == null) {
                    this.recordedErrors = recordedErrors2 = Lists.newArrayList();
                }
                recordedErrors2.add(EssentialOCLCrossReferenceSerializer.this.diagnostics.getValueConversionExceptionDiagnostic(this.semanticObject, (AbstractElement)this.crossref, (Object)unconverted, (Throwable)e));
            }
        }

        protected void report(boolean foundOne) {
            ISerializationDiagnostic.Acceptor errors2 = this.errors;
            if (errors2 != null) {
                if (this.recordedErrors != null) {
                    for (ISerializationDiagnostic diag : this.recordedErrors) {
                        errors2.accept(diag);
                    }
                }
                if (!foundOne) {
                    errors2.accept(EssentialOCLCrossReferenceSerializer.this.diagnostics.getNoEObjectDescriptionFoundDiagnostic(this.semanticObject, this.crossref, this.target, this.scope));
                }
            }
        }
    }
}

