/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.EssentialOCLCSPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpSpecificationCS;

public class EssentialOCLDeclarationVisitor
extends BaseDeclarationVisitor {
    static final Logger logger = Logger.getLogger(EssentialOCLDeclarationVisitor.class);
    @NonNull
    public static final TuplePartId TUPLE_MESSAGE_STATUS_0 = IdManager.getTuplePartId((int)0, (String)"message", (TypeId)TypeId.STRING);
    @NonNull
    public static final TuplePartId TUPLE_MESSAGE_STATUS_1 = IdManager.getTuplePartId((int)1, (String)"status", (TypeId)TypeId.BOOLEAN);
    @NonNull
    public static final TupleTypeId TUPLE_MESSAGE_STATUS = IdManager.getTupleTypeId((String)"Tuple", (TuplePartId[])new TuplePartId[]{TUPLE_MESSAGE_STATUS_0, TUPLE_MESSAGE_STATUS_1});

    public EssentialOCLDeclarationVisitor(@NonNull Pivot2CSConversion context) {
        super(context);
    }

    protected ElementCS refreshConstraint(@NonNull ConstraintCS csElement, @NonNull Constraint object) {
        String[] lines;
        int lastLineNumber;
        String body;
        if (object.eContainmentFeature() == PivotPackage.Literals.OPERATION__POSTCONDITION) {
            csElement.setStereotype("postcondition");
        } else if (object.eContainmentFeature() == PivotPackage.Literals.OPERATION__PRECONDITION) {
            csElement.setStereotype("precondition");
        } else {
            csElement.setStereotype("invariant");
        }
        OpaqueExpression specification = object.getSpecification();
        if (specification instanceof ExpressionInOCL) {
            OCLExpression bodyExpression = ((ExpressionInOCL)specification).getBodyExpression();
            if (bodyExpression instanceof TupleLiteralExp && bodyExpression.getTypeId() == TUPLE_MESSAGE_STATUS) {
                TupleLiteralPart messagePart = (TupleLiteralPart)DomainUtil.getNamedElement((Iterable)((TupleLiteralExp)bodyExpression).getPart(), (String)TUPLE_MESSAGE_STATUS_0.getName());
                TupleLiteralPart statusPart = (TupleLiteralPart)DomainUtil.getNamedElement((Iterable)((TupleLiteralExp)bodyExpression).getPart(), (String)TUPLE_MESSAGE_STATUS_1.getName());
                OCLExpression messageExpression = messagePart.getInitExpression();
                OCLExpression statusExpression = statusPart.getInitExpression();
                ExpSpecificationCS csMessage = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                csMessage.setExprString(messageExpression != null ? PrettyPrinter.print((Element)messageExpression) : "null");
                csElement.setMessageSpecification((SpecificationCS)csMessage);
                ExpSpecificationCS csStatus = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                csStatus.setExprString(statusExpression != null ? PrettyPrinter.print((Element)statusExpression) : "null");
                csElement.setSpecification((SpecificationCS)csStatus);
                return csElement;
            }
        } else if (specification != null && (body = PivotUtil.getBody((OpaqueExpression)specification)) != null && body.startsWith("Tuple") && (lastLineNumber = (lines = body.split("\n")).length - 1) >= 3 && lines[0].replaceAll("\\s", "").equals("Tuple{") && lines[1].replaceAll("\\s", "").startsWith("message:String=") && lines[lastLineNumber].replaceAll("\\s", "").equals("}.status")) {
            StringBuilder message = new StringBuilder();
            message.append(lines[1].substring(lines[1].indexOf("=") + 1, lines[1].length()).trim());
            int i = 2;
            while (i < lastLineNumber) {
                if (lines[i].replaceAll("\\s", "").startsWith("status:Boolean=")) {
                    ExpSpecificationCS csMessage = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                    String messageString = message.toString();
                    int lastIndex = messageString.lastIndexOf(44);
                    if (lastIndex > 0) {
                        messageString = messageString.substring(0, lastIndex);
                    }
                    csMessage.setExprString(messageString);
                    csElement.setMessageSpecification((SpecificationCS)csMessage);
                    StringBuilder status = new StringBuilder();
                    status.append(lines[i].substring(lines[i].indexOf("=") + 1, lines[i].length()).trim());
                    ++i;
                    while (i < lastLineNumber) {
                        status.append("\n" + lines[i]);
                        ++i;
                    }
                    ExpSpecificationCS csStatus = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                    csStatus.setExprString(status.toString());
                    csElement.setSpecification((SpecificationCS)csStatus);
                    return csElement;
                }
                message.append("\n" + lines[i]);
                ++i;
            }
        }
        csElement.setSpecification((SpecificationCS)((Pivot2CSConversion)this.context).visitDeclaration(SpecificationCS.class, (EObject)specification));
        return csElement;
    }

    @Nullable
    public ElementCS visitCallExp(@NonNull CallExp object) {
        this.safeVisit((Visitable)object.getSource());
        return null;
    }

    @Nullable
    public ElementCS visitCollectionItem(@NonNull CollectionItem object) {
        this.safeVisit((Visitable)object.getItem());
        return null;
    }

    @Nullable
    public ElementCS visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        for (CollectionLiteralPart asPart : object.getPart()) {
            this.safeVisit((Visitable)asPart);
        }
        return null;
    }

    @Nullable
    public ElementCS visitCollectionRange(@NonNull CollectionRange object) {
        this.safeVisit((Visitable)object.getFirst());
        this.safeVisit((Visitable)object.getLast());
        return null;
    }

    public ElementCS visitConstraint(@NonNull Constraint object) {
        ConstraintCS csElement = (ConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(ConstraintCS.class, BaseCSPackage.Literals.CONSTRAINT_CS, (NamedElement)object);
        if (csElement != null) {
            this.refreshConstraint(csElement, object);
        }
        return csElement;
    }

    @Nullable
    public ElementCS visitConstructorExp(@NonNull ConstructorExp object) {
        for (ConstructorPart asPart : object.getPart()) {
            this.safeVisit((Visitable)asPart);
        }
        return null;
    }

    @Nullable
    public ElementCS visitConstructorPart(@NonNull ConstructorPart object) {
        this.safeVisit((Visitable)object.getType());
        this.safeVisit((Visitable)object.getInitExpression());
        return null;
    }

    public ElementCS visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        ExpSpecificationCS csElement = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)object);
        OCLExpression bodyExpression = object.getBodyExpression();
        if (bodyExpression != null) {
            String body = PrettyPrinter.print((Element)bodyExpression);
            csElement.setExprString(body);
        }
        return csElement;
    }

    @Nullable
    public ElementCS visitIfExp(@NonNull IfExp object) {
        this.safeVisit((Visitable)object.getCondition());
        this.safeVisit((Visitable)object.getThenExpression());
        this.safeVisit((Visitable)object.getElseExpression());
        return null;
    }

    @Nullable
    public ElementCS visitLetExp(@NonNull LetExp object) {
        this.safeVisit((Visitable)object.getVariable());
        this.safeVisit((Visitable)object.getIn());
        return null;
    }

    @Nullable
    public ElementCS visitIterateExp(@NonNull IterateExp object) {
        for (Variable asIterator : object.getIterator()) {
            this.safeVisit((Visitable)asIterator);
        }
        this.safeVisit((Visitable)object.getResult());
        this.safeVisit((Visitable)object.getBody());
        return (ElementCS)super.visitIterateExp(object);
    }

    @Nullable
    public ElementCS visitIteratorExp(@NonNull IteratorExp object) {
        for (Variable asIterator : object.getIterator()) {
            this.safeVisit((Visitable)asIterator);
        }
        this.safeVisit((Visitable)object.getBody());
        return (ElementCS)super.visitIteratorExp(object);
    }

    public ElementCS visitOCLExpression(@NonNull OCLExpression object) {
        return null;
    }

    public ElementCS visitOpaqueExpression(@NonNull OpaqueExpression object) {
        String body = PivotUtil.getBody((OpaqueExpression)object);
        if (body == null) {
            return null;
        }
        ExpSpecificationCS csElement = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)object);
        csElement.setExprString(body);
        return csElement;
    }

    @Nullable
    public ElementCS visitOperationCallExp(@NonNull OperationCallExp object) {
        for (OCLExpression asArgument : object.getArgument()) {
            this.safeVisit((Visitable)asArgument);
        }
        return (ElementCS)super.visitOperationCallExp(object);
    }

    @Nullable
    public ElementCS visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        for (TupleLiteralPart asPart : object.getPart()) {
            this.safeVisit((Visitable)asPart);
        }
        return null;
    }

    @Nullable
    public ElementCS visitTupleLiteralPart(@NonNull TupleLiteralPart object) {
        this.safeVisit((Visitable)object.getType());
        this.safeVisit((Visitable)object.getInitExpression());
        return null;
    }

    @Nullable
    public ElementCS visitTypeExp(@NonNull TypeExp object) {
        this.safeVisit((Visitable)object.getType());
        return null;
    }

    @Nullable
    public ElementCS visitVariable(@NonNull Variable object) {
        this.safeVisit((Visitable)object.getType());
        this.safeVisit((Visitable)object.getInitExpression());
        return null;
    }
}

