/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.adapter;

import com.google.common.base.Preconditions;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.incquery.databinding.runtime.api.IncQueryObservables;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public abstract class DatabindingAdapter<T extends IPatternMatch> {
    private static final String SOURCE_MUST_BE_A_TYPED_PATTERN_MATCH = "Source must be a typed Pattern Match";

    public abstract String[] getParameterNames();

    public abstract IObservableValue getObservableParameter(T var1, String var2);

    protected class MatcherLabelProperty
    extends ValueProperty {
        private String expression;

        public MatcherLabelProperty(String expression) {
            this.expression = expression;
        }

        public Object getValueType() {
            return String.class;
        }

        public IObservableValue observe(Realm realm, Object source) {
            Preconditions.checkArgument((boolean)(source instanceof IPatternMatch), (Object)DatabindingAdapter.SOURCE_MUST_BE_A_TYPED_PATTERN_MATCH);
            return IncQueryObservables.getObservableLabelFeature((IPatternMatch)source, this.expression);
        }
    }

    protected class MatcherProperty
    extends ValueProperty {
        private String expression;

        public MatcherProperty(String expression) {
            this.expression = expression;
        }

        public Object getValueType() {
            return Object.class;
        }

        public IObservableValue observe(Realm realm, Object source) {
            Preconditions.checkArgument((boolean)(source instanceof IPatternMatch), (Object)DatabindingAdapter.SOURCE_MUST_BE_A_TYPED_PATTERN_MATCH);
            return IncQueryObservables.getObservableValue((IPatternMatch)source, this.expression);
        }
    }
}

