/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.properties;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyTester<RECEIVER>
extends PropertyTester
implements IProperties<RECEIVER> {
    private final String namespace;
    private final IProperties<RECEIVER> properties;

    public DefaultPropertyTester(String namespace, IProperties<RECEIVER> properties) {
        this.namespace = namespace;
        this.properties = properties;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<RECEIVER> getReceiverType() {
        return this.properties.getReceiverType();
    }

    @Override
    public Property<RECEIVER> getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public List<Property<RECEIVER>> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public void add(Property<RECEIVER> property) {
        this.properties.add(property);
    }

    public boolean test(Object receiver, String propertyName, Object[] args, Object expectedValue) {
        Property<Object> property = this.getProperty(propertyName);
        if (property == null) {
            return false;
        }
        Object typed = receiver;
        return property.testValue(typed, args, expectedValue);
    }

    public void dumpContributionMarkup() {
        System.out.println("   <extension point=\"org.eclipse.core.expressions.propertyTesters\">");
        System.out.println("      <propertyTester");
        System.out.println("         id=\"" + this.getNamespace() + ".properties\"");
        System.out.println("         type=\"" + this.getReceiverType().getName() + "\"");
        System.out.println("         namespace=\"" + this.getNamespace() + "\"");
        System.out.print("         properties=\"");
        boolean first = true;
        for (Property<RECEIVER> property : this.getProperties()) {
            if (first) {
                first = false;
            } else {
                System.out.print(",");
            }
            System.out.print(property.getName());
        }
        System.out.println("\"");
        System.out.println("         class=\"" + this.getClass().getName() + "\"/>");
        System.out.println("   </extension>");
    }
}

