/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public final class TMPUtil {
    public static final String TEMP_FOLDER_PROPERTY = "org.eclipse.net4j.util.io.tmpdir";
    public static final String SYSTEM_TEMP_FOLDER = OMPlatform.INSTANCE.getProperty("java.io.tmpdir");
    private static File tempFolder;

    private TMPUtil() {
    }

    public static synchronized File getTempFolder() {
        if (tempFolder == null) {
            String path = OMPlatform.INSTANCE.getProperty(TEMP_FOLDER_PROPERTY);
            if (path == null && (path = TMPUtil.getPathFromUserHome()) == null) {
                path = SYSTEM_TEMP_FOLDER;
            }
            if (!(tempFolder = new File(path)).exists()) {
                tempFolder.mkdirs();
            }
        }
        return tempFolder;
    }

    /*
     * Loose catch block
     */
    private static String getPathFromUserHome() {
        File home = new File(OMPlatform.INSTANCE.getProperty("user.home"));
        File file = new File(home, TEMP_FOLDER_PROPERTY);
        if (file.exists() && file.isFile()) {
            String string;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(in);
                string = properties.getProperty("path");
            }
            catch (Exception exception) {
                IOUtil.closeSilent(in);
                catch (Throwable throwable) {
                    IOUtil.closeSilent(in);
                    throw throwable;
                }
            }
            IOUtil.closeSilent(in);
            return string;
        }
        return null;
    }

    public static void setTempFolder(String tempFolder) {
        TMPUtil.tempFolder = new File(tempFolder);
    }

    public static File createTempFolder() throws IORuntimeException {
        return TMPUtil.createTempFolder("tmp");
    }

    public static File createTempFolder(String prefix) throws IORuntimeException {
        return TMPUtil.createTempFolder(prefix, "");
    }

    public static File createTempFolder(String prefix, String suffix) throws IORuntimeException {
        return TMPUtil.createTempFolder(prefix, suffix, TMPUtil.getTempFolder());
    }

    public static File createTempFolder(String prefix, String suffix, File directory) throws IORuntimeException {
        try {
            File tmp = File.createTempFile(prefix, suffix, directory);
            String tmpPath = tmp.getAbsolutePath();
            tmp.delete();
            tmp = new File(tmpPath);
            tmp.mkdirs();
            return tmp;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static File createTempFile() throws IORuntimeException {
        return TMPUtil.createTempFile("tmp");
    }

    public static File createTempFile(String prefix) throws IORuntimeException {
        return TMPUtil.createTempFile(prefix, "");
    }

    public static File createTempFile(String prefix, String suffix) throws IORuntimeException {
        return TMPUtil.createTempFile(prefix, suffix, TMPUtil.getTempFolder());
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IORuntimeException {
        try {
            return File.createTempFile(prefix, suffix, directory);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }
}

