/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;

public class DataInputOutputFile
implements DataInput,
DataOutput,
Flushable,
Closeable {
    private RandomAccessFile raf;
    private long position;
    private boolean eof;
    private byte[] buffer;
    private long start;
    private long end;
    private int used;
    private boolean modified;

    public DataInputOutputFile(File file, String mode) throws FileNotFoundException {
        this(file, mode, 8192);
    }

    public DataInputOutputFile(File file, String mode, int bufferSize) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, mode);
        this.buffer = new byte[bufferSize];
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.flush();
            this.raf.close();
            this.raf = null;
        }
    }

    public void flush() throws IOException {
        if (this.modified) {
            this.modified = false;
            this.raf.seek(this.start);
            this.raf.write(this.buffer, 0, this.used);
        }
    }

    public void seek(long filePointer) throws IOException {
        if (filePointer >= this.start && filePointer < this.end) {
            this.position = filePointer;
        } else {
            if (this.modified) {
                this.flush();
            }
            this.start = filePointer;
            this.position = filePointer;
            this.raf.seek(filePointer);
            this.used = this.raf.read(this.buffer, 0, this.buffer.length);
            if (this.used <= 0) {
                this.used = 0;
                this.eof = true;
            } else {
                this.eof = false;
            }
            this.end = this.start + (long)this.used;
        }
    }

    public long getFilePointer() throws IOException {
        return this.position;
    }

    public long length() throws IOException {
        long fileLength = this.raf.length();
        if (fileLength < this.end) {
            return this.end;
        }
        return fileLength;
    }

    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public int read() throws IOException {
        if (this.position < this.end) {
            int offset = (int)(this.position - this.start);
            ++this.position;
            return this.buffer[offset] & 0xFF;
        }
        if (this.eof) {
            return -1;
        }
        this.seek(this.position);
        return this.read();
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        if (this.eof) {
            return -1;
        }
        int available = (int)(this.end - this.position);
        if (available < 1) {
            this.seek(this.position);
            return this.read(array, offset, length);
        }
        int bytesToCopy = Math.min(length, available);
        System.arraycopy(this.buffer, (int)(this.position - this.start), array, offset, bytesToCopy);
        this.position += (long)bytesToCopy;
        if (bytesToCopy < length) {
            int remaining = length - bytesToCopy;
            if (remaining > this.buffer.length) {
                this.raf.seek(this.position);
                remaining = this.raf.read(array, offset + bytesToCopy, length - bytesToCopy);
            } else {
                this.seek(this.position);
                if (this.eof) {
                    remaining = -1;
                } else {
                    remaining = remaining > this.used ? this.used : remaining;
                    System.arraycopy(this.buffer, 0, array, offset + bytesToCopy, remaining);
                }
            }
            if (remaining > 0) {
                this.position += (long)remaining;
                return bytesToCopy + remaining;
            }
        }
        return bytesToCopy;
    }

    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] array = new byte[count];
        this.readFully(array);
        return array;
    }

    public void readFully(byte[] array) throws IOException {
        this.readFully(array, 0, array.length);
    }

    public void readFully(byte[] array, int offset, int length) throws IOException {
        int n = 0;
        while (n < length) {
            int count = this.read(array, offset + n, length - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void write(int byteValue) throws IOException {
        if (this.position < this.end) {
            int filePointer = (int)(this.position - this.start);
            this.buffer[filePointer] = (byte)byteValue;
            this.modified = true;
            ++this.position;
        } else if (this.used != this.buffer.length) {
            int filePointer = (int)(this.position - this.start);
            ++this.position;
            this.buffer[filePointer] = (byte)byteValue;
            this.modified = true;
            ++this.end;
            ++this.used;
        } else {
            this.seek(this.position);
            this.write(byteValue);
        }
    }

    public void write(byte[] array) throws IOException {
        this.write(array, 0, array.length);
    }

    public void write(byte[] array, int offset, int length) throws IOException {
        if (length < this.buffer.length) {
            long newBufferEnd;
            int freeInBuffer = 0;
            int bytesToCopy = 0;
            if (this.position >= this.start) {
                freeInBuffer = (int)(this.start + (long)this.buffer.length - this.position);
            }
            if (freeInBuffer > 0) {
                bytesToCopy = freeInBuffer > length ? length : freeInBuffer;
                System.arraycopy(array, offset, this.buffer, (int)(this.position - this.start), bytesToCopy);
                this.modified = true;
                newBufferEnd = this.position + (long)bytesToCopy;
                this.end = newBufferEnd > this.end ? newBufferEnd : this.end;
                this.used = (int)(this.end - this.start);
                this.position += (long)bytesToCopy;
            }
            if (bytesToCopy < length) {
                this.seek(this.position);
                System.arraycopy(array, offset + bytesToCopy, this.buffer, (int)(this.position - this.start), length - bytesToCopy);
                this.modified = true;
                newBufferEnd = this.position + (long)(length - bytesToCopy);
                this.end = newBufferEnd > this.end ? newBufferEnd : this.end;
                this.used = (int)(this.end - this.start);
                this.position += (long)(length - bytesToCopy);
            }
        } else {
            if (this.modified) {
                this.flush();
            }
            this.raf.seek(this.position);
            this.raf.write(array, offset, length);
            this.position += (long)length;
            this.start = this.position;
            this.used = 0;
            this.end = this.start + (long)this.used;
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public void writeByte(int value) throws IOException {
        this.write(value);
    }

    public void writeShort(int value) throws IOException {
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public void writeChar(int value) throws IOException {
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public void writeInt(int value) throws IOException {
        this.write(value >>> 24 & 0xFF);
        this.write(value >>> 16 & 0xFF);
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public void writeLong(long value) throws IOException {
        this.write((int)(value >>> 56) & 0xFF);
        this.write((int)(value >>> 48) & 0xFF);
        this.write((int)(value >>> 40) & 0xFF);
        this.write((int)(value >>> 32) & 0xFF);
        this.write((int)(value >>> 24) & 0xFF);
        this.write((int)(value >>> 16) & 0xFF);
        this.write((int)(value >>> 8) & 0xFF);
        this.write((int)value & 0xFF);
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeBytes(String value) throws IOException {
        int length = value.length();
        int i = 0;
        while (i < length) {
            this.write((byte)value.charAt(i));
            ++i;
        }
    }

    public void writeChars(String value) throws IOException {
        int length = value.length();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
            ++i;
        }
    }

    public void writeUTF(String value) throws IOException {
        char c;
        int length = value.length();
        int utf = 0;
        int i = 0;
        while (i < length) {
            c = value.charAt(i);
            utf = c >= '\u0001' && c <= '\u007f' ? ++utf : (c > '\u07ff' ? (utf += 3) : (utf += 2));
            ++i;
        }
        if (utf > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utf >>> 8 & 0xFF);
        this.write(utf & 0xFF);
        i = 0;
        while (i < length) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c & 0x3F);
            }
            ++i;
        }
    }
}

