/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainerDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetContainer<E>
extends Container<E> {
    private final Class<E> componentType;
    private final Set<E> set;

    public SetContainer(Class<E> componentType) {
        this(componentType, new HashSet());
    }

    public SetContainer(Class<E> componentType, Set<E> set) {
        this.componentType = componentType;
        this.set = set;
    }

    public final Class<E> getComponentType() {
        return this.componentType;
    }

    @Override
    public synchronized boolean isEmpty() {
        this.checkActive();
        return this.set.isEmpty();
    }

    @Override
    public synchronized E[] getElements() {
        this.checkActive();
        Object[] a = (Object[])Array.newInstance(this.componentType, this.set.size());
        Object[] array = this.set.toArray(a);
        array = this.sortElements(array);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ContainerEvent<E> event = new ContainerEvent<E>(this);
        SetContainer setContainer = this;
        synchronized (setContainer) {
            for (E element : this.set) {
                event.addDelta(element, IContainerDelta.Kind.REMOVED);
            }
            this.set.clear();
            this.notifyAll();
        }
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addElement(E element) {
        boolean added;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            block5: {
                if (this.validateElement(element)) break block5;
                return false;
            }
            added = this.set.add(element);
            this.notifyAll();
        }
        if (added) {
            this.fireElementAddedEvent(element);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(E element) {
        boolean removed;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            removed = this.set.remove(element);
            this.notifyAll();
        }
        if (removed) {
            this.fireElementRemovedEvent(element);
        }
        return removed;
    }

    protected Set<E> getSet() {
        return this.set;
    }

    protected E[] sortElements(E[] array) {
        return array;
    }

    protected boolean validateElement(E element) {
        return true;
    }
}

