/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSequencerUtil {
    @Inject
    protected IGrammarConstraintProvider gcp;

    public Map<IGrammarConstraintProvider.IConstraint, List<EObject>> getGrammarConstraints(Grammar grammar, EClass clazz) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (IGrammarConstraintProvider.IConstraintContext ctx : this.gcp.getConstraints(grammar)) {
            for (IGrammarConstraintProvider.IConstraint c : ctx.getConstraints()) {
                if (c.getType() != clazz) continue;
                List contexts = (List)result.get(c);
                if (contexts == null) {
                    contexts = Lists.newArrayList();
                    result.put(c, contexts);
                }
                contexts.add(ctx.getContext());
            }
        }
        return result;
    }

    public List<IGrammarConstraintProvider.IConstraintContext> getGrammarConstraintContexts(Grammar grammar) {
        return this.gcp.getConstraints(grammar);
    }

    protected ResourceSet cloneResourceSet(ResourceSet rs) {
        XtextResourceSet result = new XtextResourceSet();
        result.setPackageRegistry(rs.getPackageRegistry());
        result.setResourceFactoryRegistry(rs.getResourceFactoryRegistry());
        result.setURIConverter(rs.getURIConverter());
        if (rs instanceof XtextResourceSet) {
            XtextResourceSet xrs = (XtextResourceSet)rs;
            result.setClasspathURIContext(xrs.getClasspathURIContext());
            result.setClasspathUriResolver(xrs.getClasspathUriResolver());
        }
        return result;
    }

    public Grammar getSuperGrammar(Grammar grammar) {
        if (grammar.getUsedGrammars().isEmpty()) {
            return null;
        }
        SuperGrammar sg = (SuperGrammar)EcoreUtil.getExistingAdapter((Notifier)grammar, SuperGrammar.class);
        if (sg != null) {
            return sg.getGrammar();
        }
        URI uri = ((Grammar)grammar.getUsedGrammars().get(0)).eResource().getURI();
        Resource resource = this.cloneResourceSet(grammar.eResource().getResourceSet()).getResource(uri, true);
        Grammar result = (Grammar)resource.getContents().get(0);
        grammar.eAdapters().add((Object)new SuperGrammar(result));
        return result;
    }

    public Collection<IGrammarConstraintProvider.IConstraint> getGrammarConstraints(Grammar grammar) {
        if (grammar == null) {
            return Collections.emptySet();
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (IGrammarConstraintProvider.IConstraintContext ctx : this.gcp.getConstraints(grammar)) {
            result.addAll(ctx.getConstraints());
        }
        return result;
    }

    public boolean canGenerate(IGrammarConstraintProvider.IConstraint constraint) {
        if (constraint.getAssignments().length != constraint.getFeatures().length) {
            return false;
        }
        IGrammarConstraintProvider.IConstraintElement body = constraint.getBody();
        if (body == null) {
            return false;
        }
        if (!(body.getFeatureInfo() == null || body.isOptional() || body.isMany() || body.getFeatureInfo().getFeature().isMany())) {
            return true;
        }
        if (body.getType() == IGrammarConstraintProvider.ConstraintElementType.GROUP) {
            if (body.getGrammarElement() instanceof UnorderedGroup) {
                return false;
            }
            for (IGrammarConstraintProvider.IConstraintElement child : body.getChildren()) {
                if (child.getFeatureInfo() != null && !child.isOptional() && !child.isMany() && !child.getFeatureInfo().getFeature().isMany()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toAcceptMethod(IGrammarConstraintProvider.ConstraintElementType type) {
        switch (type) {
            case ASSIGNED_ACTION_CALL: {
                return "acceptAssignedAction";
            }
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: {
                return "acceptAssignedCrossRefDatatype";
            }
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: {
                return "acceptAssignedCrossRefEnum";
            }
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: {
                return "acceptAssignedCrossRefTerminal";
            }
            case ASSIGNED_CROSSREF_KEYWORD: {
                return "acceptAssignedCrossRefKeyword";
            }
            case ASSIGNED_DATATYPE_RULE_CALL: {
                return "acceptAssignedDatatype";
            }
            case ASSIGNED_ENUM_RULE_CALL: {
                return "acceptAssignedEnum";
            }
            case ASSIGNED_KEYWORD: {
                return "acceptAssignedKeyword";
            }
            case ASSIGNED_PARSER_RULE_CALL: {
                return "acceptAssignedParserRuleCall";
            }
            case ASSIGNED_TERMINAL_RULE_CALL: {
                return "acceptAssignedTerminal";
            }
        }
        return "<error, unknown type +'" + type + "'>";
    }

    public String toNodeType(IGrammarConstraintProvider.ConstraintElementType type) {
        switch (type) {
            case ASSIGNED_ACTION_CALL: 
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
            case ASSIGNED_CROSSREF_KEYWORD: 
            case ASSIGNED_DATATYPE_RULE_CALL: 
            case ASSIGNED_ENUM_RULE_CALL: 
            case ASSIGNED_PARSER_RULE_CALL: {
                return ICompositeNode.class.getSimpleName();
            }
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
            case ASSIGNED_KEYWORD: 
            case ASSIGNED_TERMINAL_RULE_CALL: {
                return ILeafNode.class.getSimpleName();
            }
        }
        return "<error, unknown type +'" + type + "'>";
    }

    protected static class SuperGrammar
    extends AdapterImpl {
        protected Grammar grammar;

        public SuperGrammar(Grammar grammar) {
            this.grammar = grammar;
        }

        public Grammar getGrammar() {
            return this.grammar;
        }

        public boolean isAdapterForType(Object type) {
            return type == SuperGrammar.class;
        }
    }
}

