/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.internal.launching.remote.AntSecurityException;
import org.eclipse.ant.internal.launching.remote.AntSecurityManager;
import org.eclipse.ant.internal.launching.remote.DemuxInputStreamSetter;
import org.eclipse.ant.internal.launching.remote.ExecutorSetter;
import org.eclipse.ant.internal.launching.remote.InputHandlerSetter;
import org.eclipse.ant.internal.launching.remote.RemoteAntMessages;
import org.eclipse.ant.internal.launching.remote.logger.RemoteAntBuildLogger;

public class InternalAntRunner {
    public static final int MSG_PROJECT_HELP = 5;
    private List<String> buildListeners;
    private String buildFileLocation;
    private Vector<String> targets;
    private Map<String, String> userProperties;
    private Project currentProject;
    private BuildLogger buildLogger = null;
    private Map<String, String> eclipseSpecifiedTasks;
    private Map<String, String> eclipseSpecifiedTypes;
    private String antVersionNumber = null;
    private int messageOutputLevel = 2;
    private boolean emacsMode = false;
    private boolean projectHelp = false;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private String loggerClassname = null;
    private String[] extraArguments = null;
    private boolean scriptExecuted = false;
    private List<String> propertyFiles = new ArrayList<String>();
    private String inputHandlerClassname = null;
    private boolean keepGoing = false;
    private boolean allowInput = true;
    private String fEarlyErrorMessage = null;

    public static void main(String[] args) {
        try {
            new InternalAntRunner().run(InternalAntRunner.getArrayList(args));
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static ArrayList<String> getArrayList(String[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    private void addBuildListeners(Project project) {
        String clazz = null;
        try {
            BuildLogger logger = this.createLogger();
            if (logger != null) {
                project.addBuildListener((BuildListener)logger);
            }
            if (this.buildListeners != null) {
                Iterator<String> iterator = this.buildListeners.iterator();
                while (iterator.hasNext()) {
                    String className;
                    clazz = className = iterator.next();
                    Class<?> listener = Class.forName(className);
                    project.addBuildListener((BuildListener)listener.newInstance());
                }
            }
        }
        catch (ClassCastException e) {
            String message = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.{0}_which_was_specified_to_be_a_build_listener_is_not_an_instance_of_org.apache.tools.ant.BuildListener._1"), clazz);
            this.logMessage(null, message, 0);
            throw new BuildException(message, (Throwable)e);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void parseBuildFile(Project project) {
        File buildFile = new File(this.getBuildFileLocation());
        if (!buildFile.exists()) {
            throw new BuildException(MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Buildfile__{0}_does_not_exist_!_1"), buildFile.getAbsolutePath()));
        }
        if (!buildFile.isFile()) {
            throw new BuildException(MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Buildfile__{0}_is_not_a_file_1"), buildFile.getAbsolutePath()));
        }
        if (!this.isVersionCompatible("1.5")) {
            this.parseBuildFile(project, buildFile);
        } else {
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)helper);
            helper.parse(project, (Object)buildFile);
        }
    }

    @Deprecated
    private void parseBuildFile(Project project, File buildFile) {
        ProjectHelper.configureProject((Project)project, (File)buildFile);
    }

    private void printArguments(Project project) {
        if (this.messageOutputLevel != 4 && this.messageOutputLevel != 3) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.extraArguments.length) {
            sb.append(this.extraArguments[i]);
            sb.append(' ');
            ++i;
        }
        project.log(MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Arguments__{0}_2"), sb.toString().trim()));
    }

    private void printTargets(Project project) {
        this.logMessage(project, "", 5);
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        ArrayList<String> topNames = new ArrayList<String>();
        ArrayList<String> topDescriptions = new ArrayList<String>();
        ArrayList<String> subNames = new ArrayList<String>();
        while (ptargets.hasMoreElements()) {
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                subNames.add(targetName);
                continue;
            }
            topNames.add(targetName);
            topDescriptions.add(targetDescription);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Collections.sort(subNames);
        Collections.sort(topNames);
        Collections.sort(topDescriptions);
        String defaultTargetName = project.getDefaultTarget();
        if (defaultTargetName != null && !"".equals(defaultTargetName)) {
            ArrayList<String> defaultName = new ArrayList<String>(1);
            ArrayList<String> defaultDesc = null;
            defaultName.add(defaultTargetName);
            int indexOfDefDesc = topNames.indexOf(defaultTargetName);
            if (indexOfDefDesc >= 0) {
                defaultDesc = new ArrayList<String>(1);
                defaultDesc.add((String)topDescriptions.get(indexOfDefDesc));
            }
            this.printTargets(project, defaultName, defaultDesc, RemoteAntMessages.getString("InternalAntRunner.Default_target__3"), maxLength);
        }
        this.printTargets(project, topNames, topDescriptions, RemoteAntMessages.getString("InternalAntRunner.Main_targets__4"), maxLength);
        this.printTargets(project, subNames, null, RemoteAntMessages.getString("InternalAntRunner.Subtargets__5"), 0);
    }

    private void printTargets(Project project, List<String> names, List<String> descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = String.valueOf(spaces) + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(String.valueOf(heading) + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(' ');
            msg.append(names.get(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - names.get(i).length() + 2));
                msg.append(descriptions.get(i));
            }
            msg.append(lSep);
            ++i;
        }
        this.logMessage(project, msg.toString(), 2);
    }

    private void run(List<String> argList) {
        this.setCurrentProject(new Project());
        if (this.isVersionCompatible("1.6.3")) {
            new ExecutorSetter().setExecutor(this.getCurrentProject());
        }
        Throwable error = null;
        PrintStream originalErr = System.err;
        PrintStream originalOut = System.out;
        InputStream originalIn = System.in;
        SecurityManager originalSM = System.getSecurityManager();
        this.scriptExecuted = true;
        try {
            if (argList != null && (argList.remove("-projecthelp") || argList.remove("-p"))) {
                this.projectHelp = true;
            }
            this.getCurrentProject().init();
            if (argList != null) {
                this.scriptExecuted = this.preprocessCommandLine(argList);
                if (!this.scriptExecuted) {
                    return;
                }
            }
            boolean exceptionState = this.processProperties(argList);
            this.addBuildListeners(this.getCurrentProject());
            this.addInputHandler(this.getCurrentProject());
            this.remapSystemIn();
            System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(this.getCurrentProject(), false)));
            System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(this.getCurrentProject(), true)));
            if (!this.projectHelp) {
                this.fireBuildStarted(this.getCurrentProject());
            }
            if (this.fEarlyErrorMessage != null) {
                this.logMessage(this.getCurrentProject(), this.fEarlyErrorMessage, 0);
                if (exceptionState) {
                    throw new BuildException(this.fEarlyErrorMessage);
                }
            }
            this.setProperties(this.getCurrentProject());
            if (argList != null && !argList.isEmpty()) {
                try {
                    this.scriptExecuted = this.processCommandLine(argList);
                }
                catch (BuildException e) {
                    this.scriptExecuted = false;
                    throw e;
                }
            }
            if (!this.scriptExecuted) {
                return;
            }
            if (this.allowInput && this.inputHandlerClassname != null && this.inputHandlerClassname.length() > 0) {
                if (this.isVersionCompatible("1.6")) {
                    this.getCurrentProject().setDefaultInputStream(originalIn);
                }
            } else {
                System.setProperty("eclipse.ant.noInput", "true");
                if (this.isVersionCompatible("1.5") && (this.inputHandlerClassname == null || this.inputHandlerClassname.length() == 0)) {
                    InputHandlerSetter setter = new InputHandlerSetter();
                    setter.setInputHandler(this.getCurrentProject(), "org.eclipse.ant.internal.launching.remote.inputhandler.FailInputHandler");
                }
            }
            this.getCurrentProject().log(MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Build_file__{0}_1"), this.getBuildFileLocation()));
            this.setTasks();
            this.setTypes();
            if (this.isVersionCompatible("1.6")) {
                this.getCurrentProject().setKeepGoingMode(this.keepGoing);
            }
            this.parseBuildFile(this.getCurrentProject());
            if (this.projectHelp) {
                this.printHelp(this.getCurrentProject());
                this.scriptExecuted = false;
                return;
            }
            try {
                if (this.extraArguments != null) {
                    this.printArguments(this.getCurrentProject());
                }
                System.setSecurityManager(new AntSecurityManager(originalSM, Thread.currentThread()));
                if (this.targets == null) {
                    this.targets = new Vector(1);
                }
                if (this.targets.isEmpty() && this.getCurrentProject().getDefaultTarget() != null) {
                    this.targets.add(this.getCurrentProject().getDefaultTarget());
                }
                if (!this.isVersionCompatible("1.6.3")) {
                    this.getCurrentProject().addReference("eclipse.ant.targetVector", this.targets);
                }
                this.getCurrentProject().executeTargets(this.targets);
            }
            catch (AntSecurityException antSecurityException) {
            }
            catch (Throwable e) {
                error = e;
            }
        }
        finally {
            System.setErr(originalErr);
            System.setOut(originalOut);
            System.setIn(originalIn);
            if (System.getSecurityManager() instanceof AntSecurityManager) {
                System.setSecurityManager(originalSM);
            }
            if (!this.projectHelp) {
                this.fireBuildFinished(this.getCurrentProject(), error);
            }
            if (this.err != originalErr) {
                this.err.close();
            }
            if (this.out != originalOut) {
                this.out.close();
            }
        }
    }

    private void setTasks() {
        if (this.eclipseSpecifiedTasks != null) {
            for (Map.Entry<String, String> entry : this.eclipseSpecifiedTasks.entrySet()) {
                String taskName = entry.getKey();
                String taskClassName = entry.getValue();
                if (this.isVersionCompatible("1.6")) {
                    AntTypeDefinition def = new AntTypeDefinition();
                    def.setName(taskName);
                    def.setClassName(taskClassName);
                    def.setClassLoader(this.getClass().getClassLoader());
                    def.setAdaptToClass(Task.class);
                    def.setAdapterClass(TaskAdapter.class);
                    ComponentHelper.getComponentHelper((Project)this.getCurrentProject()).addDataTypeDefinition(def);
                    continue;
                }
                try {
                    Class<?> taskClass = Class.forName(taskClassName);
                    this.getCurrentProject().addTaskDefinition(taskName, taskClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String message = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.161"), taskClassName, taskName);
                    this.getCurrentProject().log(message, 1);
                }
            }
        }
    }

    private void setTypes() {
        if (this.eclipseSpecifiedTypes != null) {
            for (Map.Entry<String, String> entry : this.eclipseSpecifiedTypes.entrySet()) {
                String typeName = entry.getKey();
                String typeClassName = entry.getValue();
                if (this.isVersionCompatible("1.6")) {
                    AntTypeDefinition def = new AntTypeDefinition();
                    def.setName(typeName);
                    def.setClassName(typeClassName);
                    def.setClassLoader(this.getClass().getClassLoader());
                    ComponentHelper.getComponentHelper((Project)this.getCurrentProject()).addDataTypeDefinition(def);
                    continue;
                }
                try {
                    Class<?> typeClass = Class.forName(typeClassName);
                    this.getCurrentProject().addDataTypeDefinition(typeName, typeClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String message = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.162"), typeClassName, typeName);
                    this.getCurrentProject().log(message, 1);
                }
            }
        }
    }

    private void remapSystemIn() {
        if (!this.isVersionCompatible("1.6")) {
            return;
        }
        DemuxInputStreamSetter setter = new DemuxInputStreamSetter();
        setter.remapSystemIn(this.getCurrentProject());
    }

    private BuildLogger createLogger() {
        if (this.loggerClassname == null) {
            this.buildLogger = new DefaultLogger();
        } else if (!"".equals(this.loggerClassname)) {
            try {
                this.buildLogger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException e) {
                String message = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.{0}_which_was_specified_to_perform_logging_is_not_an_instance_of_org.apache.tools.ant.BuildLogger._2"), this.loggerClassname);
                this.logMessage(null, message, 0);
                throw new BuildException(message, (Throwable)e);
            }
            catch (Exception e) {
                String message = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Unable_to_instantiate_logger__{0}_6"), this.loggerClassname);
                this.logMessage(null, message, 0);
                throw new BuildException(message, (Throwable)e);
            }
        }
        if (this.buildLogger != null) {
            this.buildLogger.setMessageOutputLevel(this.messageOutputLevel);
            this.buildLogger.setOutputPrintStream(this.out);
            this.buildLogger.setErrorPrintStream(this.err);
            this.buildLogger.setEmacsMode(this.emacsMode);
            if (this.buildLogger instanceof RemoteAntBuildLogger) {
                ((RemoteAntBuildLogger)this.buildLogger).configure(this.userProperties);
            }
        }
        return this.buildLogger;
    }

    private void fireBuildStarted(Project project) {
        if (!this.isVersionCompatible("1.5")) {
            BuildEvent event = new BuildEvent(project);
            for (BuildListener listener : project.getBuildListeners()) {
                listener.buildStarted(event);
            }
        } else {
            project.fireBuildStarted();
        }
    }

    private void fireBuildFinished(Project project, Throwable error) {
        if (error == null && this.scriptExecuted) {
            this.logMessage(project, RemoteAntMessages.getString("InternalAntRunner.BUILD_SUCCESSFUL_1"), this.messageOutputLevel);
        }
        if (!this.isVersionCompatible("1.5")) {
            BuildEvent event = new BuildEvent(project);
            event.setException(error);
            for (BuildListener listener : project.getBuildListeners()) {
                listener.buildFinished(event);
            }
        } else {
            project.fireBuildFinished(error);
        }
    }

    private void logMessage(Project project, String message, int priority) {
        if (project != null) {
            project.log(message, priority);
        }
    }

    private void setBuildFileLocation(String buildFileLocation) {
        this.buildFileLocation = buildFileLocation;
        if (this.getCurrentProject() != null) {
            this.getCurrentProject().setUserProperty("ant.file", buildFileLocation);
        }
    }

    private String getBuildFileLocation() {
        if (this.buildFileLocation == null) {
            this.buildFileLocation = new File("build.xml").getAbsolutePath();
        }
        return this.buildFileLocation;
    }

    private void setMessageOutputLevel(int level) {
        this.messageOutputLevel = level;
        if (this.buildLogger != null) {
            this.buildLogger.setMessageOutputLevel(level);
        }
    }

    private String getAntVersionNumber() throws BuildException {
        if (this.antVersionNumber == null) {
            try {
                String versionNumber;
                Properties props = new Properties();
                InputStream in = Main.class.getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                this.antVersionNumber = versionNumber = props.getProperty("VERSION");
            }
            catch (IOException ioe) {
                throw new BuildException(MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Could_not_load_the_version_information._{0}_9"), ioe.getMessage()));
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException(RemoteAntMessages.getString("InternalAntRunner.Could_not_load_the_version_information._10"));
            }
        }
        return this.antVersionNumber;
    }

    private boolean isVersionCompatible(String comparison) {
        String version = this.getAntVersionNumber();
        return version.compareTo(comparison) >= 0;
    }

    private boolean preprocessCommandLine(List<String> commands) {
        String arg = this.getArgument(commands, "-listener");
        while (arg != null) {
            if (arg.length() == 0) {
                throw new BuildException(RemoteAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-listener_argument_1"));
            }
            if (this.buildListeners == null) {
                this.buildListeners = new ArrayList<String>(1);
            }
            this.buildListeners.add(arg);
            arg = this.getArgument(commands, "-listener");
        }
        arg = this.getArgument(commands, "-logger");
        if (arg != null) {
            this.loggerClassname = arg;
        }
        if ((arg = this.getArgument(commands, "-logger")) != null) {
            throw new BuildException(RemoteAntMessages.getString("InternalAntRunner.Only_one_logger_class_may_be_specified_1"));
        }
        arg = this.getArgument(commands, "-inputhandler");
        if (arg != null) {
            if (arg.length() == 0) {
                throw new BuildException(RemoteAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-inputhandler_argument_1"));
            }
            this.inputHandlerClassname = arg;
        }
        if ((arg = this.getArgument(commands, "-inputhandler")) != null) {
            throw new BuildException(RemoteAntMessages.getString("InternalAntRunner.Only_one_input_handler_class_may_be_specified._2"));
        }
        return true;
    }

    private boolean processCommandLine(List<String> commands) {
        if (commands.remove("-help") || commands.remove("-h")) {
            this.printUsage();
            return false;
        }
        if (commands.remove("-version")) {
            this.printVersion();
            return false;
        }
        if (commands.remove("-verbose") || commands.remove("-v")) {
            this.printVersion();
            this.setMessageOutputLevel(3);
        }
        if (commands.remove("-debug") || commands.remove("-d")) {
            this.printVersion();
            this.setMessageOutputLevel(4);
        }
        if (commands.remove("-quiet") || commands.remove("-q")) {
            this.setMessageOutputLevel(1);
        }
        if (commands.remove("-emacs") || commands.remove("-e")) {
            this.emacsMode = true;
            if (this.buildLogger != null) {
                this.buildLogger.setEmacsMode(true);
            }
        }
        if (commands.remove("-diagnostics")) {
            if (!this.isVersionCompatible("1.5")) {
                throw new BuildException(RemoteAntMessages.getString("InternalAntRunner.The_diagnositics_options_is_an_Ant_1.5.*_feature._Please_update_your_Ant_classpath_to_include_an_Ant_version_greater_than_this._4"));
            }
            try {
                Diagnostics.doReport((PrintStream)System.out);
            }
            catch (NullPointerException nullPointerException) {
                this.logMessage(this.getCurrentProject(), RemoteAntMessages.getString("InternalAntRunner.ANT_HOME_must_be_set_to_use_Ant_diagnostics_2"), 0);
            }
            return false;
        }
        String arg = this.getArgument(commands, "-logfile");
        if (arg == null) {
            arg = this.getArgument(commands, "-l");
        }
        if (arg != null) {
            if (arg.length() == 0) {
                String message = RemoteAntMessages.getString("InternalAntRunner.You_must_specify_a_log_file_when_using_the_-log_argument_3");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            try {
                this.createLogFile(arg);
            }
            catch (IOException iOException) {
                this.logMessage(this.getCurrentProject(), MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Could_not_write_to_the_specified_log_file__{0}._Make_sure_the_path_exists_and_you_have_write_permissions._2"), arg), 0);
                return false;
            }
        }
        if ((arg = this.getArgument(commands, "-buildfile")) == null && (arg = this.getArgument(commands, "-file")) == null) {
            arg = this.getArgument(commands, "-f");
        }
        if (arg != null) {
            if (arg.length() == 0) {
                String message = RemoteAntMessages.getString("InternalAntRunner.You_must_specify_a_buildfile_when_using_the_-buildfile_argument_4");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            this.setBuildFileLocation(arg);
        }
        if (this.isVersionCompatible("1.6")) {
            if (commands.remove("-k") || commands.remove("-keep-going")) {
                this.keepGoing = true;
            }
            if (commands.remove("-noinput")) {
                this.allowInput = false;
            }
            if ((arg = this.getArgument(commands, "-lib")) != null) {
                this.logMessage(this.currentProject, RemoteAntMessages.getString("InternalAntRunner.157"), 0);
                return false;
            }
        }
        if ((arg = this.getArgument(commands, "-find")) == null) {
            arg = this.getArgument(commands, "-s");
        }
        if (arg != null) {
            this.logMessage(this.currentProject, RemoteAntMessages.getString("InternalAntRunner.-find_not_supported"), 0);
            return false;
        }
        this.processTasksAndTypes(commands);
        if (!commands.isEmpty()) {
            this.processUnrecognizedCommands(commands);
        }
        if (!commands.isEmpty()) {
            this.processTargets(commands);
        }
        return true;
    }

    private void processTasksAndTypes(List<String> commands) {
        String className;
        String name;
        int index;
        String arg = this.getArgument(commands, "-eclipseTask");
        while (arg != null) {
            if (this.eclipseSpecifiedTasks == null) {
                this.eclipseSpecifiedTasks = new HashMap<String, String>();
            }
            if ((index = arg.indexOf(44)) != -1) {
                name = arg.substring(0, index);
                className = arg.substring(index + 1);
                this.eclipseSpecifiedTasks.put(name, className);
            }
            arg = this.getArgument(commands, "-eclipseTask");
        }
        arg = this.getArgument(commands, "-eclipseType");
        while (arg != null) {
            if (this.eclipseSpecifiedTypes == null) {
                this.eclipseSpecifiedTypes = new HashMap<String, String>();
            }
            if ((index = arg.indexOf(44)) != -1) {
                name = arg.substring(0, index);
                className = arg.substring(index + 1);
                this.eclipseSpecifiedTypes.put(name, className);
            }
            arg = this.getArgument(commands, "-eclipseType");
        }
    }

    private void processUnrecognizedCommands(List<String> commands) {
        int p = -1;
        int i = commands.size() - 1;
        while (i >= 0) {
            if (commands.get(0).startsWith("-")) {
                p = i;
                break;
            }
            --i;
        }
        if (p < 0) {
            return;
        }
        String s = "";
        int i2 = 0;
        while (i2 <= p) {
            s = String.valueOf(s) + " " + commands.get(0);
            commands.remove(0);
            ++i2;
        }
        String message = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Unknown_argument__{0}_2"), s.substring(1));
        this.logMessage(this.currentProject, message, 1);
    }

    private void processTargets(List<String> commands) {
        if (this.targets == null) {
            this.targets = new Vector(commands.size());
        }
        for (String string : commands) {
            this.targets.add(string);
        }
    }

    private void createLogFile(String fileName) throws FileNotFoundException, IOException {
        File logFile = this.getFileRelativeToBaseDir(fileName);
        this.err = this.out = new PrintStream(new FileOutputStream(logFile));
        this.logMessage(this.getCurrentProject(), MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Using_{0}_file_as_build_log._1"), logFile.getCanonicalPath()), 2);
        if (this.buildLogger != null) {
            this.buildLogger.setErrorPrintStream(this.err);
            this.buildLogger.setOutputPrintStream(this.out);
        }
    }

    private File getFileRelativeToBaseDir(String fileName) {
        File parentFile = null;
        String base = this.getCurrentProject().getUserProperty("basedir");
        parentFile = base != null ? new File(base) : new File(this.getBuildFileLocation()).getParentFile();
        return FileUtils.getFileUtils().resolveFile(parentFile, fileName);
    }

    private boolean processProperties(List<String> commands) {
        boolean exceptionToBeThrown = false;
        String arg = this.getArgument(commands, "-propertyfile");
        while (arg != null) {
            if (!this.isVersionCompatible("1.5")) {
                this.fEarlyErrorMessage = RemoteAntMessages.getString("InternalAntRunner.Specifying_property_files_is_a_Ant_1.5.*_feature._Please_update_your_Ant_classpath._6");
                break;
            }
            if (arg.length() == 0) {
                this.fEarlyErrorMessage = RemoteAntMessages.getString("InternalAntRunner.You_must_specify_a_property_filename_when_using_the_-propertyfile_argument_3");
                exceptionToBeThrown = true;
                break;
            }
            this.propertyFiles.add(arg);
            arg = this.getArgument(commands, "-propertyfile");
        }
        if (this.propertyFiles != null && !this.propertyFiles.isEmpty()) {
            this.loadPropertyFiles();
        }
        if (commands != null) {
            this.processMinusDProperties(commands);
        }
        return exceptionToBeThrown;
    }

    private void processMinusDProperties(List<String> commands) {
        String[] args = commands.toArray(new String[commands.size()]);
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq == 0) {
                    value = name.substring(1);
                    name = "";
                } else if (posEq > 0 && posEq != name.length() - 1) {
                    value = name.substring(posEq + 1).trim();
                    name = name.substring(0, posEq);
                }
                if (value != null) {
                    if (this.userProperties == null) {
                        this.userProperties = new HashMap<String, String>();
                    }
                    this.userProperties.put(name, value);
                    commands.remove(args[i]);
                }
            }
            ++i;
        }
    }

    private void setProperties(Project project) {
        this.setBuiltInProperties(project);
        if (this.userProperties != null) {
            for (Map.Entry<String, String> entry : this.userProperties.entrySet()) {
                project.setUserProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setBuiltInProperties(Project project) {
        project.setUserProperty("ant.file", this.getBuildFileLocation());
        project.setUserProperty("ant.version", Main.getAntVersion());
    }

    private void printHelp(Project project) {
        if (project.getDescription() != null) {
            this.logMessage(project, project.getDescription(), 2);
        }
        this.printTargets(project);
    }

    private void printVersion() {
        this.logMessage(this.getCurrentProject(), Main.getAntVersion(), 2);
    }

    private void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.options_13"));
        msg.append("] [");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.target_15"));
        msg.append(" [");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.target_15"));
        msg.append("2 [");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.target_15"));
        msg.append("3] ...]]");
        msg.append(lSep);
        msg.append(RemoteAntMessages.getString("InternalAntRunner.Options___21"));
        msg.append(lSep);
        msg.append("\t-help, -h\t\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.print_this_message_23"));
        msg.append(lSep);
        msg.append("\t-projecthelp, -p\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.print_project_help_information_25"));
        msg.append(lSep);
        msg.append("\t-version\t\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.print_the_version_information_and_exit_27"));
        msg.append(lSep);
        msg.append("\t-diagnostics\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.12"));
        msg.append(lSep);
        msg.append(RemoteAntMessages.getString("InternalAntRunner.13"));
        msg.append(lSep);
        msg.append("\t-quiet, -q\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.be_extra_quiet_29"));
        msg.append(lSep);
        msg.append("\t-verbose, -v\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.be_extra_verbose_31"));
        msg.append(lSep);
        msg.append("\t-debug, -d\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.print_debugging_information_33"));
        msg.append(lSep);
        msg.append("\t-emacs, -e\t\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.produce_logging_information_without_adornments_35"));
        msg.append(lSep);
        msg.append("\t-logfile\t<file>\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.use_given_file_for_log_37"));
        msg.append(lSep);
        msg.append("\t\t-l\t<file>");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.1"));
        msg.append(lSep);
        msg.append("\t-logger <classname>\t\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.the_class_which_is_to_perform_logging_39"));
        msg.append(lSep);
        msg.append("\t-listener <classname>\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.add_an_instance_of_class_as_a_project_listener_41"));
        msg.append(lSep);
        msg.append("\t-noinput\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.158"));
        msg.append(lSep);
        msg.append("\t-buildfile\t<file>\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.use_given_buildfile_43"));
        msg.append(lSep);
        msg.append("\t\t-file\t<file>");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.1"));
        msg.append(lSep);
        msg.append("\t\t-f\t\t<file>");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.1"));
        msg.append(lSep);
        msg.append("\t-D<property>=<value>\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.use_value_for_given_property_45"));
        msg.append(lSep);
        msg.append("\t-keep-going, -k");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.159"));
        msg.append(lSep);
        msg.append(RemoteAntMessages.getString("InternalAntRunner.160"));
        msg.append(lSep);
        msg.append("\t-propertyfile <name>\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.19"));
        msg.append(lSep);
        msg.append(RemoteAntMessages.getString("InternalAntRunner.20"));
        msg.append(lSep);
        msg.append("\t-inputhandler <class>\t");
        msg.append(RemoteAntMessages.getString("InternalAntRunner.22"));
        msg.append(lSep);
        this.logMessage(this.getCurrentProject(), msg.toString(), 2);
    }

    private String getArgument(List<String> commands, String param) {
        if (commands == null) {
            return null;
        }
        int index = commands.indexOf(param);
        if (index == -1) {
            return null;
        }
        commands.remove(index);
        if (index == commands.size()) {
            return "";
        }
        String command = commands.get(index);
        if (command.startsWith("-")) {
            return "";
        }
        commands.remove(index);
        return command;
    }

    private Project getCurrentProject() {
        return this.currentProject;
    }

    private void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }

    private void loadPropertyFiles() {
        for (String filename : this.propertyFiles) {
            Properties props;
            block17: {
                File file = this.getFileRelativeToBaseDir(filename);
                props = new Properties();
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(file);
                        props.load(fis);
                    }
                    catch (IOException e) {
                        this.fEarlyErrorMessage = MessageFormat.format(RemoteAntMessages.getString("InternalAntRunner.Could_not_load_property_file_{0}__{1}_4"), filename, e.getMessage());
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.userProperties == null) {
                this.userProperties = new HashMap<String, String>();
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (this.userProperties.get(name) != null) continue;
                this.userProperties.put(name, props.getProperty(name));
            }
        }
    }

    private void addInputHandler(Project project) {
        if (!this.isVersionCompatible("1.5")) {
            return;
        }
        InputHandlerSetter setter = new InputHandlerSetter();
        setter.setInputHandler(project, this.inputHandlerClassname);
    }
}

