/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.support;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.core.ISupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIntegrationEntry;
import org.eclipse.chemclipse.logging.core.Logger;

public class IdentificationSupport {
    private static final Logger logger = Logger.getLogger(IdentificationSupport.class);
    public static final String NOT_AVAILABLE = "n.a.";

    public String[] getIdentifierNames(String[] identifierIds) {
        int size = identifierIds.length;
        String[] processorNames = new String[size];
        int index = 0;
        while (index < size) {
            processorNames[index] = this.getIdentifierName(identifierIds[index]);
            ++index;
        }
        return processorNames;
    }

    public String getIdentifierName(IPeakIntegrationEntry entry) {
        return this.getIdentifierName(entry.getProcessorId());
    }

    public String getIdentifierName(String identifierId) {
        String processorName = NOT_AVAILABLE;
        try {
            ISupplier peakIdentifierSupplier = PeakIdentifier.getPeakIdentifierSupport().getIdentifierSupplier(identifierId);
            processorName = peakIdentifierSupplier.getIdentifierName();
        }
        catch (NoIdentifierAvailableException e) {
            logger.warn((Object)e);
        }
        return processorName;
    }

    public String[] getPluginIds() {
        String[] pluginIds = new String[]{NOT_AVAILABLE};
        try {
            List ids = PeakIdentifier.getPeakIdentifierSupport().getAvailableIdentifierIds();
            pluginIds = ids.toArray(new String[ids.size()]);
        }
        catch (NoIdentifierAvailableException e) {
            logger.warn((Object)e);
        }
        return pluginIds;
    }

    public String getIdentifierId(String name) {
        String[] identifierIds = this.getPluginIds();
        String[] identifierNames = this.getIdentifierNames(identifierIds);
        int index = 0;
        String[] stringArray = identifierNames;
        int n = identifierNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.equals(name)) {
                return identifierIds[index];
            }
            ++index;
            ++n2;
        }
        return "";
    }
}

