/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class QrUpdate {
    private DenseMatrix64F Q;
    private DenseMatrix64F R;
    private DenseMatrix64F U_tran;
    private DenseMatrix64F Qm;
    private double[] r_row;
    private int maxCols;
    private int maxRows;
    private int m;
    private int n;
    private int m_m;
    private boolean autoGrow;

    public QrUpdate(int maxRows, int maxCols) {
        this.autoGrow = false;
        this.declareInternalData(maxRows, maxCols);
    }

    public QrUpdate(int maxRows, int maxCols, boolean autoGrow) {
        this.autoGrow = autoGrow;
        this.declareInternalData(maxRows, maxCols);
    }

    public QrUpdate() {
        this.autoGrow = true;
    }

    public void declareInternalData(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.U_tran = new DenseMatrix64F(maxRows, maxRows);
        this.Qm = new DenseMatrix64F(maxRows, maxRows);
        this.r_row = new double[maxCols];
    }

    public void addRow(DenseMatrix64F Q, DenseMatrix64F R, double[] row, int rowIndex, boolean resizeR) {
        this.setQR(Q, R, 1);
        this.m_m = this.m + 1;
        if (Q.data.length < this.m_m * this.m_m) {
            throw new IllegalArgumentException("Q matrix does not have enough data to grow");
        }
        if (resizeR && R.data.length < this.m_m * this.n) {
            throw new IllegalArgumentException("R matrix does not have enough data to grow");
        }
        if (resizeR) {
            R.reshape(this.m_m, this.n, false);
        }
        this.U_tran.reshape(this.m_m, this.m_m, false);
        this.applyFirstGivens(row);
        this.applyLaterGivens();
        this.updateInsertQ(rowIndex);
        this.R = null;
        this.Q = null;
    }

    public void deleteRow(DenseMatrix64F Q, DenseMatrix64F R, int rowIndex, boolean resizeR) {
        this.setQR(Q, R, 0);
        if (this.m - 1 < this.n) {
            throw new IllegalArgumentException("Removing any row would make the system under determined.");
        }
        this.m_m = this.m - 1;
        this.U_tran.reshape(this.m, this.m, false);
        if (resizeR) {
            R.reshape(this.m_m, this.n, false);
        }
        this.computeRemoveGivens(rowIndex);
        this.updateRemoveQ(rowIndex);
        this.updateRemoveR();
        this.R = null;
        this.Q = null;
    }

    private void setQR(DenseMatrix64F Q, DenseMatrix64F R, int growRows) {
        if (Q.numRows != Q.numCols) {
            throw new IllegalArgumentException("Q should be square.");
        }
        this.Q = Q;
        this.R = R;
        this.m = Q.numRows;
        this.n = R.numCols;
        if (this.m + growRows > this.maxRows || this.n > this.maxCols) {
            if (this.autoGrow) {
                this.declareInternalData(this.m + growRows, this.n);
            } else {
                throw new IllegalArgumentException("Autogrow has been set to false and the maximum number of rows or columns has been exceeded.");
            }
        }
    }

    private void updateInsertQ(int rowIndex) {
        int k;
        double sum;
        int j;
        this.Qm.set(this.Q);
        this.Q.reshape(this.m_m, this.m_m, false);
        int i = 0;
        while (i < rowIndex) {
            j = 0;
            while (j < this.m_m) {
                sum = 0.0;
                k = 0;
                while (k < this.m) {
                    sum += this.Qm.data[i * this.m + k] * this.U_tran.data[j * this.m_m + k + 1];
                    ++k;
                }
                this.Q.data[i * this.m_m + j] = sum;
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < this.m_m) {
            this.Q.data[rowIndex * this.m_m + j2] = this.U_tran.data[j2 * this.m_m];
            ++j2;
        }
        i = rowIndex + 1;
        while (i < this.m_m) {
            j = 0;
            while (j < this.m_m) {
                sum = 0.0;
                k = 0;
                while (k < this.m) {
                    sum += this.Qm.data[(i - 1) * this.m + k] * this.U_tran.data[j * this.m_m + k + 1];
                    ++k;
                }
                this.Q.data[i * this.m_m + j] = sum;
                ++j;
            }
            ++i;
        }
    }

    private void updateRemoveQ(int rowIndex) {
        int k;
        double sum;
        int j;
        this.Qm.set(this.Q);
        this.Q.reshape(this.m_m, this.m_m, false);
        int i = 0;
        while (i < rowIndex) {
            j = 1;
            while (j < this.m) {
                sum = 0.0;
                k = 0;
                while (k < this.m) {
                    sum += this.Qm.data[i * this.m + k] * this.U_tran.data[j * this.m + k];
                    ++k;
                }
                this.Q.data[i * this.m_m + j - 1] = sum;
                ++j;
            }
            ++i;
        }
        i = rowIndex + 1;
        while (i < this.m) {
            j = 1;
            while (j < this.m) {
                sum = 0.0;
                k = 0;
                while (k < this.m) {
                    sum += this.Qm.data[i * this.m + k] * this.U_tran.data[j * this.m + k];
                    ++k;
                }
                this.Q.data[(i - 1) * this.m_m + j - 1] = sum;
                ++j;
            }
            ++i;
        }
    }

    private void updateRemoveR() {
        int i = 1;
        while (i < this.n + 1) {
            int j = 0;
            while (j < this.n) {
                double sum = 0.0;
                int k = i - 1;
                while (k <= j) {
                    sum += this.U_tran.data[i * this.m + k] * this.R.data[k * this.n + j];
                    ++k;
                }
                this.R.data[(i - 1) * this.n + j] = sum;
                ++j;
            }
            ++i;
        }
    }

    private void applyFirstGivens(double[] row) {
        double s;
        double c;
        double xi = row[0];
        double xj = this.R.data[0];
        double r = xi * xi + xj * xj;
        if (r != 0.0) {
            r = Math.sqrt(r);
            c = xi / r;
            s = xj / r;
        } else {
            c = 1.0;
            s = 0.0;
        }
        this.R.data[0] = r;
        int col = 1;
        while (col < this.n) {
            double vali = row[col];
            double valj = this.R.data[col];
            this.R.data[col] = c * vali + s * valj;
            this.r_row[col] = c * valj - s * vali;
            ++col;
        }
        CommonOps.setIdentity(this.U_tran);
        this.U_tran.data[0] = c;
        this.U_tran.data[1] = s;
        this.U_tran.data[this.m_m] = -s;
        this.U_tran.data[this.m_m + 1] = c;
    }

    private void applyLaterGivens() {
        int row = 1;
        while (row < this.n) {
            double s;
            double c;
            double xi = this.r_row[row];
            double xj = this.R.data[this.n * row + row];
            double r = xi * xi + xj * xj;
            if (r != 0.0) {
                r = Math.sqrt(r);
                c = xi / r;
                s = xj / r;
            } else {
                c = 1.0;
                s = 0.0;
            }
            this.R.data[this.n * row + row] = r;
            int col = row + 1;
            while (col < this.n) {
                double vali = this.r_row[col];
                double valj = this.R.data[this.n * row + col];
                this.R.data[this.n * row + col] = c * vali + s * valj;
                this.r_row[col] = c * valj - s * vali;
                ++col;
            }
            col = 0;
            while (col <= row + 1) {
                double q1 = this.U_tran.data[row * this.m_m + col];
                double q2 = this.U_tran.data[(row + 1) * this.m_m + col];
                this.U_tran.data[row * this.m_m + col] = c * q1 + s * q2;
                this.U_tran.data[(row + 1) * this.m_m + col] = c * q2 - s * q1;
                ++col;
            }
            ++row;
        }
    }

    private void computeRemoveGivens(int selectedRow) {
        CommonOps.setIdentity(this.U_tran);
        double xj = this.Q.data[selectedRow * this.m + this.m - 1];
        int j = this.m - 2;
        while (j >= 0) {
            double s;
            double c;
            double xi = this.Q.data[selectedRow * this.m + j];
            double r = xi * xi + xj * xj;
            if (r != 0.0) {
                r = Math.sqrt(r);
                c = xi / r;
                s = xj / r;
            } else {
                c = 1.0;
                s = 0.0;
            }
            xj = r;
            int col = j;
            while (col < this.m) {
                double q1 = this.U_tran.data[j * this.m + col];
                double q2 = this.U_tran.data[(j + 1) * this.m + col];
                this.U_tran.data[j * this.m + col] = c * q1 + s * q2;
                this.U_tran.data[(j + 1) * this.m + col] = c * q2 - s * q1;
                ++col;
            }
            --j;
        }
    }

    public DenseMatrix64F getU_tran() {
        return this.U_tran;
    }
}

