/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.ops.CommonOps;

public class HessenbergSimilarDecomposition_D64
implements DecompositionInterface<DenseMatrix64F> {
    private DenseMatrix64F QH;
    private int N;
    private double[] gammas;
    private double[] b;
    private double[] u;

    public HessenbergSimilarDecomposition_D64(int initialSize) {
        this.gammas = new double[initialSize];
        this.b = new double[initialSize];
        this.u = new double[initialSize];
    }

    public HessenbergSimilarDecomposition_D64() {
        this(5);
    }

    @Override
    public boolean decompose(DenseMatrix64F A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("A must be square.");
        }
        if (A.numRows <= 0) {
            return false;
        }
        this.QH = A;
        this.N = A.numCols;
        if (this.b.length < this.N) {
            this.b = new double[this.N];
            this.gammas = new double[this.N];
            this.u = new double[this.N];
        }
        return this._decompose();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    public DenseMatrix64F getQH() {
        return this.QH;
    }

    public DenseMatrix64F getH(DenseMatrix64F H) {
        if (H == null) {
            H = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != H.numRows || this.N != H.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            H.zero();
        }
        System.arraycopy(this.QH.data, 0, H.data, 0, this.N);
        int i = 1;
        while (i < this.N) {
            int j = i - 1;
            while (j < this.N) {
                H.set(i, j, this.QH.get(i, j));
                ++j;
            }
            ++i;
        }
        return H;
    }

    public DenseMatrix64F getQ(DenseMatrix64F Q) {
        if (Q == null) {
            Q = new DenseMatrix64F(this.N, this.N);
            int i = 0;
            while (i < this.N) {
                Q.data[i * this.N + i] = 1.0;
                ++i;
            }
        } else {
            if (this.N != Q.numRows || this.N != Q.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(Q);
        }
        int j = this.N - 2;
        while (j >= 0) {
            this.u[j + 1] = 1.0;
            int i = j + 2;
            while (i < this.N) {
                this.u[i] = this.QH.get(i, j);
                ++i;
            }
            QrHelperFunctions_D64.rank1UpdateMultR(Q, this.u, this.gammas[j], j + 1, j + 1, this.N, this.b);
            --j;
        }
        return Q;
    }

    private boolean _decompose() {
        double[] h = this.QH.data;
        int k = 0;
        while (k < this.N - 2) {
            double max = 0.0;
            int i = k + 1;
            while (i < this.N) {
                double val = this.u[i] = h[i * this.N + k];
                if ((val = Math.abs(val)) > max) {
                    max = val;
                }
                ++i;
            }
            if (max > 0.0) {
                double gamma;
                double tau = 0.0;
                int i2 = k + 1;
                while (i2 < this.N) {
                    int n = i2++;
                    double d = this.u[n] / max;
                    this.u[n] = d;
                    double val = d;
                    tau += val * val;
                }
                tau = Math.sqrt(tau);
                if (this.u[k + 1] < 0.0) {
                    tau = -tau;
                }
                double nu = this.u[k + 1] + tau;
                this.u[k + 1] = 1.0;
                int i3 = k + 2;
                while (i3 < this.N) {
                    int n = i3;
                    double d = this.u[n] / nu;
                    this.u[n] = d;
                    h[i3 * this.N + k] = d;
                    ++i3;
                }
                this.gammas[k] = gamma = nu / tau;
                QrHelperFunctions_D64.rank1UpdateMultR(this.QH, this.u, gamma, k + 1, k + 1, this.N, this.b);
                QrHelperFunctions_D64.rank1UpdateMultL(this.QH, this.u, gamma, 0, k + 1, this.N);
                h[(k + 1) * this.N + k] = -tau * max;
            } else {
                this.gammas[k] = 0.0;
            }
            ++k;
        }
        return true;
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

