/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

public class BlockInnerMultiplication {
    public static void blockMultPlus(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int a = indexA;
        int rowC = indexC;
        int i = 0;
        while (i < heightA) {
            int b = indexB;
            int endC = rowC + widthC;
            int endA = a + widthA;
            while (a != endA) {
                double valA = dataA[a++];
                int c = rowC;
                while (c != endC) {
                    int n = c++;
                    dataC[n] = dataC[n] + valA * dataB[b++];
                }
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultPlusTransA(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int rowC = indexC;
        int i = 0;
        while (i < widthA) {
            int colA = i + indexA;
            int endA = colA + widthA * heightA;
            int b = indexB;
            while (colA != endA) {
                double valA = dataA[colA];
                int c = rowC;
                int endB = b + widthC;
                while (b != endB) {
                    int n = c++;
                    dataC[n] = dataC[n] + valA * dataB[b++];
                }
                colA += widthA;
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultPlusTransB(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int i = 0;
        while (i < heightA) {
            int j = 0;
            while (j < widthC) {
                double val = 0.0;
                int k = 0;
                while (k < widthA) {
                    val += dataA[i * widthA + k + indexA] * dataB[j * widthA + k + indexB];
                    ++k;
                }
                int n = i * widthC + j + indexC;
                dataC[n] = dataC[n] + val;
                ++j;
            }
            ++i;
        }
    }

    public static void blockMultMinus(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int a = indexA;
        int rowC = indexC;
        int i = 0;
        while (i < heightA) {
            int b = indexB;
            int endC = rowC + widthC;
            int endA = a + widthA;
            while (a != endA) {
                double valA = dataA[a++];
                int c = rowC;
                while (c != endC) {
                    int n = c++;
                    dataC[n] = dataC[n] - valA * dataB[b++];
                }
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultMinusTransA(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int rowC = indexC;
        int i = 0;
        while (i < widthA) {
            int colA = i + indexA;
            int endA = colA + widthA * heightA;
            int b = indexB;
            while (colA != endA) {
                double valA = dataA[colA];
                int c = rowC;
                int endB = b + widthC;
                while (b != endB) {
                    int n = c++;
                    dataC[n] = dataC[n] - valA * dataB[b++];
                }
                colA += widthA;
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultMinusTransB(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int i = 0;
        while (i < heightA) {
            int j = 0;
            while (j < widthC) {
                double val = 0.0;
                int k = 0;
                while (k < widthA) {
                    val += dataA[i * widthA + k + indexA] * dataB[j * widthA + k + indexB];
                    ++k;
                }
                int n = i * widthC + j + indexC;
                dataC[n] = dataC[n] - val;
                ++j;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void blockMultSet(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        a = indexA;
        rowC = indexC;
        i = 0;
        while (i < heightA) {
            b = indexB;
            endC = rowC + widthC;
            endA = a + widthA;
            while (a != endA) {
                valA = dataA[a++];
                c = rowC;
                if (b != indexB) ** GOTO lbl18
                while (c != endC) {
                    dataC[c++] = valA * dataB[b++];
                }
                continue;
lbl-1000:
                // 1 sources

                {
                    v0 = c++;
                    dataC[v0] = dataC[v0] + valA * dataB[b++];
lbl18:
                    // 2 sources

                    ** while (c != endC)
                }
lbl19:
                // 1 sources

            }
            ++i;
            rowC += widthC;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void blockMultSetTransA(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        rowC = indexC;
        i = 0;
        while (i < widthA) {
            colA = i + indexA;
            endA = colA + widthA * heightA;
            b = indexB;
            while (colA != endA) {
                block4: {
                    valA = dataA[colA];
                    c = rowC;
                    endB = b + widthC;
                    if (b != indexB) ** GOTO lbl18
                    while (b != endB) {
                        dataC[c++] = valA * dataB[b++];
                    }
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        v0 = c++;
                        dataC[v0] = dataC[v0] + valA * dataB[b++];
lbl18:
                        // 2 sources

                        ** while (b != endB)
                    }
                }
                colA += widthA;
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultSetTransB(double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int i = 0;
        while (i < heightA) {
            int j = 0;
            while (j < widthC) {
                double val = 0.0;
                int k = 0;
                while (k < widthA) {
                    val += dataA[i * widthA + k + indexA] * dataB[j * widthA + k + indexB];
                    ++k;
                }
                dataC[i * widthC + j + indexC] = val;
                ++j;
            }
            ++i;
        }
    }

    public static void blockMultPlus(double alpha, double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int a = indexA;
        int rowC = indexC;
        int i = 0;
        while (i < heightA) {
            int b = indexB;
            int endC = rowC + widthC;
            int endA = a + widthA;
            while (a != endA) {
                double valA = alpha * dataA[a++];
                int c = rowC;
                while (c != endC) {
                    int n = c++;
                    dataC[n] = dataC[n] + valA * dataB[b++];
                }
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultPlusTransA(double alpha, double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int rowC = indexC;
        int i = 0;
        while (i < widthA) {
            int colA = i + indexA;
            int endA = colA + widthA * heightA;
            int b = indexB;
            while (colA != endA) {
                double valA = alpha * dataA[colA];
                int c = rowC;
                int endB = b + widthC;
                while (b != endB) {
                    int n = c++;
                    dataC[n] = dataC[n] + valA * dataB[b++];
                }
                colA += widthA;
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultPlusTransB(double alpha, double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int i = 0;
        while (i < heightA) {
            int j = 0;
            while (j < widthC) {
                double val = 0.0;
                int k = 0;
                while (k < widthA) {
                    val += dataA[i * widthA + k + indexA] * dataB[j * widthA + k + indexB];
                    ++k;
                }
                int n = i * widthC + j + indexC;
                dataC[n] = dataC[n] + alpha * val;
                ++j;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void blockMultSet(double alpha, double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        a = indexA;
        rowC = indexC;
        i = 0;
        while (i < heightA) {
            b = indexB;
            endC = rowC + widthC;
            endA = a + widthA;
            while (a != endA) {
                valA = alpha * dataA[a++];
                c = rowC;
                if (b != indexB) ** GOTO lbl18
                while (c != endC) {
                    dataC[c++] = valA * dataB[b++];
                }
                continue;
lbl-1000:
                // 1 sources

                {
                    v0 = c++;
                    dataC[v0] = dataC[v0] + valA * dataB[b++];
lbl18:
                    // 2 sources

                    ** while (c != endC)
                }
lbl19:
                // 1 sources

            }
            ++i;
            rowC += widthC;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void blockMultSetTransA(double alpha, double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        rowC = indexC;
        i = 0;
        while (i < widthA) {
            colA = i + indexA;
            endA = colA + widthA * heightA;
            b = indexB;
            while (colA != endA) {
                block4: {
                    valA = alpha * dataA[colA];
                    c = rowC;
                    endB = b + widthC;
                    if (b != indexB) ** GOTO lbl18
                    while (b != endB) {
                        dataC[c++] = valA * dataB[b++];
                    }
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        v0 = c++;
                        dataC[v0] = dataC[v0] + valA * dataB[b++];
lbl18:
                        // 2 sources

                        ** while (b != endB)
                    }
                }
                colA += widthA;
            }
            ++i;
            rowC += widthC;
        }
    }

    public static void blockMultSetTransB(double alpha, double[] dataA, double[] dataB, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int i = 0;
        while (i < heightA) {
            int j = 0;
            while (j < widthC) {
                double val = 0.0;
                int k = 0;
                while (k < widthA) {
                    val += dataA[i * widthA + k + indexA] * dataB[j * widthA + k + indexB];
                    ++k;
                }
                dataC[i * widthC + j + indexC] = alpha * val;
                ++j;
            }
            ++i;
        }
    }
}

