/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.IonSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.AbstractViewMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.msd.swt.ui.exceptions.NoIonAvailableException;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.BarSeriesUtil;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.IBarSeriesIon;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.IBarSeriesIons;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.IBarSeries;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;

public abstract class AbstractExtendedMassSpectrumUI
extends AbstractViewMassSpectrumUI {
    protected IBarSeries barSeriesPositive = null;
    protected IBarSeries barSeriesNegative = null;
    private static final Logger logger = Logger.getLogger(AbstractExtendedMassSpectrumUI.class);
    private Color foregroundColor;
    private static final int NUMBER_OF_IONS_TO_PAINT = 5;
    private MassValueDisplayPrecision massValueDisplayPrecision;
    private DecimalFormat decimalFormatExact;
    private StringBuilder stringBuilder;

    public AbstractExtendedMassSpectrumUI(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.decimalFormatExact = ValueFormat.getDecimalFormatEnglish((String)"0.0#####");
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void mouseDoubleClick(MouseEvent event) {
        super.mouseDoubleClick(event);
        try {
            int widthPlotArea = this.getPlotArea().getBounds().width;
            double ion = BarSeriesUtil.getSelectedIon(event.x, this.barSeriesPositive, widthPlotArea);
            this.updateSelectedIon(ion);
        }
        catch (NoIonAvailableException e) {
            logger.warn((Object)e);
        }
    }

    private void updateSelectedIon(double ion) {
        if (this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
            ChromatogramSelectionMSD actualChromatogramSelection = (ChromatogramSelectionMSD)this.chromatogramSelection;
            IMarkedIons selectedIons = actualChromatogramSelection.getSelectedIons();
            this.updateIon(selectedIons, ion);
            ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionMSD)this.chromatogramSelection, (boolean)false);
        }
        IonSelectionUpdateNotifier.fireUpdateChange((double)ion);
    }

    private void updateIon(IMarkedIons selectedIons, double ion) {
        switch (this.massValueDisplayPrecision) {
            case NOMINAL: {
                this.updateNominalIon(selectedIons, (int)ion);
                break;
            }
            case EXACT: {
                this.updateExactIon(selectedIons, ion);
                break;
            }
            case TRANSITION: {
                this.updateExactIon(selectedIons, ion);
            }
        }
    }

    private void updateNominalIon(IMarkedIons selectedIons, int ion) {
        assert (selectedIons != null) : "The selected ions instance must not be null.";
        if (selectedIons.getIonsNominal().contains(ion)) {
            selectedIons.remove((Object)new MarkedIon((double)ion));
        } else {
            selectedIons.add((Object)new MarkedIon((double)ion));
        }
    }

    private void updateExactIon(IMarkedIons selectedIons, double ion) {
        assert (selectedIons != null) : "The selected ions instance must not be null.";
        MarkedIon markedIon = new MarkedIon(ion);
        if (selectedIons.contains((Object)markedIon)) {
            selectedIons.remove((Object)markedIon);
        } else {
            selectedIons.add((Object)new MarkedIon(ion));
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.foregroundColor = Display.getDefault().getSystemColor(2);
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                if (AbstractExtendedMassSpectrumUI.this.barSeriesPositive != null) {
                    AbstractExtendedMassSpectrumUI.this.paintIonValues(AbstractExtendedMassSpectrumUI.this.barSeriesPositive, false, e);
                }
                if (AbstractExtendedMassSpectrumUI.this.barSeriesNegative != null) {
                    AbstractExtendedMassSpectrumUI.this.paintIonValues(AbstractExtendedMassSpectrumUI.this.barSeriesNegative, true, e);
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
    }

    protected void paintIonValues(IBarSeries barSeries, boolean mirrored, PaintEvent e) {
        e.gc.setForeground(this.foregroundColor);
        List<IBarSeriesIon> barSeriesIons = this.getHighestXValueIndices(barSeries, mirrored);
        for (IBarSeriesIon barSeriesIon : barSeriesIons) {
            String label;
            Point point = barSeries.getPixelCoordinates(barSeriesIon.getIndex());
            double ion = barSeriesIon.getIon();
            switch (this.massValueDisplayPrecision) {
                case NOMINAL: {
                    label = String.valueOf((int)ion);
                    break;
                }
                case EXACT: {
                    label = this.decimalFormatExact.format(ion);
                    break;
                }
                case TRANSITION: {
                    label = this.decimalFormatExact.format(ion);
                    break;
                }
                default: {
                    label = String.valueOf((int)ion);
                }
            }
            if (this.massSpectrum != null && this.massValueDisplayPrecision == MassValueDisplayPrecision.TRANSITION) {
                try {
                    IIon mz = this.massSpectrum.getIon(ion);
                    IIonTransition ionTransition = mz.getIonTransition();
                    if (ionTransition != null) {
                        this.clearStringBuilder();
                        this.stringBuilder.append(Integer.toString((int)ionTransition.getQ1StartIon()));
                        this.stringBuilder.append(" > ");
                        this.stringBuilder.append(label);
                        this.stringBuilder.append(" @");
                        this.stringBuilder.append(Integer.toString((int)ionTransition.getCollisionEnergy()));
                        label = this.stringBuilder.toString();
                    }
                }
                catch (AbundanceLimitExceededException e1) {
                    logger.warn((Object)e1);
                }
                catch (IonLimitExceededException e1) {
                    logger.warn((Object)e1);
                }
            }
            Point labelSize = e.gc.textExtent(label);
            int x = (int)((double)point.x + (double)barSeries.getBarWidth() / 2.0 - (double)labelSize.x / 2.0);
            int y = point.y;
            if (!mirrored) {
                y = point.y - labelSize.y;
            }
            e.gc.drawText(label, x, y, true);
        }
    }

    private void clearStringBuilder() {
        this.stringBuilder.delete(0, this.stringBuilder.length());
    }

    private List<IBarSeriesIon> getHighestXValueIndices(IBarSeries barSeries, boolean mirrored) {
        int numberOfIonsToPaint = PreferenceSupplier.getScanDisplayNumberOfIons();
        if (numberOfIonsToPaint < 0) {
            numberOfIonsToPaint = 5;
        }
        int widthPlotArea = this.getPlotArea().getBounds().width;
        IBarSeriesIons barSeriesIons = BarSeriesUtil.getBarSeriesIonList(barSeries, widthPlotArea);
        List<IBarSeriesIon> barSeriesIonList = PreferenceSupplier.isUseModuloDisplayNumberOfIons() ? barSeriesIons.getIonsByModulo(numberOfIonsToPaint, mirrored) : barSeriesIons.getIonsWithHighestAbundance(numberOfIonsToPaint, mirrored);
        return barSeriesIonList;
    }

    protected ISeries getSeries(IScanMSD massSpectrum) {
        ISeries series;
        switch (this.massValueDisplayPrecision) {
            case NOMINAL: {
                series = SeriesConverterMSD.convertNominalMassSpectrum(massSpectrum, Sign.POSITIVE);
                break;
            }
            case EXACT: {
                series = SeriesConverterMSD.convertExactMassSpectrum(massSpectrum, Sign.POSITIVE);
                break;
            }
            case TRANSITION: {
                series = SeriesConverterMSD.convertExactMassSpectrum(massSpectrum, Sign.POSITIVE);
                break;
            }
            default: {
                series = SeriesConverterMSD.convertNominalMassSpectrum(massSpectrum, Sign.POSITIVE);
            }
        }
        return series;
    }
}

