/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.chromatogram;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.comparator.ChromatogramPeakComparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.chromatogram.AbstractEditorChromatogramUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.exceptions.NoIdentifiedScansAvailableException;
import org.eclipse.chemclipse.swt.ui.exceptions.NoPeaksAvailableException;
import org.eclipse.chemclipse.swt.ui.marker.MouseMoveMarker;
import org.eclipse.chemclipse.swt.ui.marker.SelectedPositionMarker;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class EditorChromatogramUI
extends AbstractEditorChromatogramUI {
    private MouseMoveMarker mouseMoveMarker;
    private SelectedPositionMarker selectedPositionMarker;
    private ChromatogramPeakComparator chromatogramPeakComparator;

    public EditorChromatogramUI(Composite parent, int style) {
        super(parent, style);
        boolean yMinimumToZero = PreferenceSupplier.showBackgroundInChromatogramEditor();
        this.setYMinimumToZero(yMinimumToZero);
        this.chromatogramPeakComparator = new ChromatogramPeakComparator(SortOrder.ASC);
    }

    public void setViewSeries() {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionMSD) {
            ILineSeries scatterSeries;
            IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)storedChromatogramSelection;
            boolean showChromatogramArea = PreferenceSupplier.showChromatogramArea();
            ISeries series = SeriesConverter.convertChromatogram((IChromatogramSelection)chromatogramSelection, (Sign)Sign.POSITIVE, (boolean)true);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(showChromatogramArea);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            Color chromatogramColor = PreferenceSupplier.getChromatogramColor();
            if (chromatogramColor == null) {
                chromatogramColor = Colors.RED;
            }
            lineSeries.setLineColor(chromatogramColor);
            IVendorMassSpectrum selectedScan = chromatogramSelection.getSelectedScan();
            if (selectedScan != null) {
                series = this.getScanSeries((IScan)selectedScan, "Selected Scan");
                ILineSeries selectedScanSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                selectedScanSeries.setXSeries(series.getXSeries());
                selectedScanSeries.setYSeries(series.getYSeries());
                selectedScanSeries.setLineStyle(LineStyle.NONE);
                selectedScanSeries.setSymbolType(ILineSeries.PlotSymbolType.CROSS);
                selectedScanSeries.setSymbolSize(5);
                selectedScanSeries.setSymbolColor(Colors.DARK_RED);
            }
            try {
                series = SeriesConverterMSD.convertPeakMaxPositions(chromatogramSelection, (IOffset)new Offset(0.0, 0.0), Sign.POSITIVE, true);
                scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                scatterSeries.setXSeries(series.getXSeries());
                scatterSeries.setYSeries(series.getYSeries());
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                scatterSeries.setSymbolSize(5);
                scatterSeries.setLineColor(Colors.GRAY);
                scatterSeries.setSymbolColor(Colors.DARK_GRAY);
            }
            catch (NoPeaksAvailableException noPeaksAvailableException) {}
            try {
                series = SeriesConverterMSD.convertPeakMaxPositions(chromatogramSelection, (IOffset)new Offset(0.0, 0.0), Sign.POSITIVE, false);
                scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                scatterSeries.setXSeries(series.getXSeries());
                scatterSeries.setYSeries(series.getYSeries());
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                scatterSeries.setSymbolSize(5);
                scatterSeries.setLineColor(Colors.GRAY);
                scatterSeries.setSymbolColor(Colors.GRAY);
            }
            catch (NoPeaksAvailableException noPeaksAvailableException) {}
            IChromatogramPeakMSD peak = chromatogramSelection.getSelectedPeak();
            if (peak != null && PreferenceSupplier.showSelectedPeakInEditor()) {
                series = SeriesConverter.convertSelectedPeak((IPeak)peak, (boolean)true, (Sign)Sign.POSITIVE);
                ILineSeries peakSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                peakSeries.setXSeries(series.getXSeries());
                peakSeries.setYSeries(series.getYSeries());
                peakSeries.enableArea(true);
                if (PreferenceSupplier.showScansOfSelectedPeak()) {
                    peakSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                    peakSeries.setSymbolColor(Colors.DARK_RED);
                    int size = PreferenceSupplier.sizeOfPeakScanMarker();
                    peakSeries.setSymbolSize(size);
                } else {
                    peakSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                }
                peakSeries.setLineColor(Colors.DARK_RED);
                series = SeriesConverter.convertSelectedPeakBackground((IPeak)peak, (Sign)Sign.POSITIVE);
                ILineSeries backgroundSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                backgroundSeries.setXSeries(series.getXSeries());
                backgroundSeries.setYSeries(series.getYSeries());
                backgroundSeries.enableArea(true);
                backgroundSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                backgroundSeries.setLineColor(Colors.BLACK);
            }
            try {
                series = SeriesConverterMSD.convertIdentifiedScans(chromatogramSelection, (IOffset)new Offset(0.0, 0.0), Sign.POSITIVE);
                scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                scatterSeries.setXSeries(series.getXSeries());
                scatterSeries.setYSeries(series.getYSeries());
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                scatterSeries.setSymbolSize(3);
                scatterSeries.setLineColor(Colors.GRAY);
                scatterSeries.setSymbolColor(Colors.DARK_GRAY);
                IVendorMassSpectrum selectedIdentifiedScan = chromatogramSelection.getSelectedIdentifiedScan();
                if (selectedIdentifiedScan != null) {
                    series = this.getScanSeries((IScan)selectedIdentifiedScan, "Selected Identified Scan");
                    ILineSeries selectedIdentifiedScanSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                    selectedIdentifiedScanSeries.setXSeries(series.getXSeries());
                    selectedIdentifiedScanSeries.setYSeries(series.getYSeries());
                    selectedIdentifiedScanSeries.setLineStyle(LineStyle.NONE);
                    selectedIdentifiedScanSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                    selectedIdentifiedScanSeries.setSymbolSize(5);
                    selectedIdentifiedScanSeries.setSymbolColor(Colors.DARK_RED);
                }
            }
            catch (NoIdentifiedScansAvailableException noIdentifiedScansAvailableException) {}
        }
    }

    private ISeries getScanSeries(IScan selectedScan, String id) {
        double[] xSeries = new double[]{selectedScan.getRetentionTime()};
        int totalSignal = (int)selectedScan.getTotalSignal();
        double[] ySeries = new double[]{totalSignal};
        return new Series(xSeries, ySeries, id);
    }

    protected void initialize() {
        super.initialize();
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        this.mouseMoveMarker = new MouseMoveMarker();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.mouseMoveMarker);
        if (PreferenceSupplier.showChromatogramPositionMarkerBox()) {
            Color foregroundColor = PreferenceSupplier.getPositionMarkerForegroundColor();
            Color backgroundColor = PreferenceSupplier.getPositionMarkerBackgroundColor();
            this.selectedPositionMarker = new SelectedPositionMarker(foregroundColor, backgroundColor);
            plotArea.addCustomPaintListener((ICustomPaintListener)this.selectedPositionMarker);
            this.getPlotArea().addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    EditorChromatogramUI.this.mouseMoveMarker.setXPosition(e.x);
                    double abundance = EditorChromatogramUI.this.getSelectedAbundance(e.y);
                    int retentionTimeInMilliseconds = EditorChromatogramUI.this.getSelectedRetentionTimeAsMilliseconds(e.x);
                    EditorChromatogramUI.this.selectedPositionMarker.setActualPosition(retentionTimeInMilliseconds, abundance);
                    EditorChromatogramUI.this.getPlotArea().redraw();
                }
            });
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.button == 1) {
            if (e.stateMask == 262144) {
                this.handlePeakSelection(e.x);
            } else {
                this.handleScanSelection(e.x);
            }
        }
    }

    public void mouseScrolled(MouseEvent e) {
        this.handleMouseWheelSelection(e);
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.keyCode;
        int stateMask = e.stateMask;
        if (stateMask == 262144) {
            if (keyCode == 0x1000004 || keyCode == 0x1000003) {
                this.handleControlScanSelection(keyCode);
            } else {
                super.keyPressed(e);
            }
        } else if (keyCode == 0x1000004 || keyCode == 0x1000003 || keyCode == 0x1000001 || keyCode == 0x1000002) {
            this.handleArrowMoveWindowSelection(keyCode);
        }
    }

    private void handlePeakSelection(int x) {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)storedChromatogramSelection;
            int retentionTime = this.getRetentionTime(x);
            IChromatogramPeakMSD selectedPeak = chromatogramSelection.getChromatogramMSD().getPeak(retentionTime);
            if (selectedPeak != null) {
                chromatogramSelection.setSelectedPeak(selectedPeak, true);
                if (PreferenceSupplier.isMoveRetentionTimeOnPeakSelection()) {
                    this.adjustChromatogramSelection(selectedPeak, chromatogramSelection);
                }
                chromatogramSelection.update(true);
            }
        }
    }

    private void adjustChromatogramSelection(IChromatogramPeakMSD selectedPeak, IChromatogramSelectionMSD chromatogramSelection) {
        IChromatogramMSD chromatogramMSD = chromatogramSelection.getChromatogramMSD();
        List peaks = chromatogramMSD.getPeaks();
        List peaksSelection = chromatogramMSD.getPeaks(chromatogramSelection);
        Collections.sort(peaks, this.chromatogramPeakComparator);
        Collections.sort(peaksSelection, this.chromatogramPeakComparator);
        if (!((IChromatogramPeakMSD)peaks.get(0)).equals(selectedPeak) && !((IChromatogramPeakMSD)peaks.get(peaks.size() - 1)).equals(selectedPeak)) {
            if (((IChromatogramPeakMSD)peaksSelection.get(0)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
            } else if (((IChromatogramPeakMSD)peaksSelection.get(peaksSelection.size() - 1)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
            }
        }
    }
}

