/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.swt.ui.components.chromatogram.AbstractViewChromatogramUI;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class MirroredMultipleChromatogramOffsetUI
extends AbstractViewChromatogramUI {
    private IOffset offset;

    public MirroredMultipleChromatogramOffsetUI(Composite parent, int style, IOffset offset, IAxisTitles axisTitles) {
        super(parent, style, axisTitles);
    }

    public void setOffset(IOffset offset) {
        this.offset = offset != null ? offset : new Offset(0.0, 0.0);
    }

    @Override
    public void setViewSeries() {
        boolean showChromatogramArea = PreferenceSupplier.showChromatogramArea();
        String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
        IColorScheme colorScheme = Colors.getColorScheme(colorSchemeOverlay);
        IMultipleSeries multipleSeries = SeriesConverter.convertChromatogramsMirrored(this.getChromatogramSelections(), this.offset, true);
        int size = multipleSeries.getMultipleSeries().size();
        int i = 0;
        while (i < size) {
            ISeries series = multipleSeries.getMultipleSeries().get(i);
            this.setAdditionalChromatogramSeries(series, colorScheme.getColor(), showChromatogramArea);
            colorScheme.incrementColor();
            ++i;
        }
    }

    private void setAdditionalChromatogramSeries(ISeries series, Color color, boolean showChromatogramArea) {
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(showChromatogramArea);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(color);
    }
}

