/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.result.IDurbinWatsonClassifierResult;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.ui.internal.provider.ClassifierResultContentProvider;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.ui.internal.provider.ClassifierResultLabelProvider;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.ui.internal.provider.ClassifierResultTableComparator;
import org.eclipse.chemclipse.model.core.IChromatogramResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class DurbinWatsonResultsView
extends AbstractChromatogramSelectionMSDView {
    private static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.ui.views.durbinWatsonResultsView.popup";
    @Inject
    private Composite parent;
    private ExtendedTableViewer tableViewer;
    private ClassifierResultTableComparator classifierResultTableComparator;
    private String[] titles = new String[]{"Rating", "Derivative", "Order", "Width"};
    private int[] bounds = new int[]{100, 100, 100, 100};

    @Inject
    public DurbinWatsonResultsView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(this.parent, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new ClassifierResultContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ClassifierResultLabelProvider());
        this.classifierResultTableComparator = new ClassifierResultTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.classifierResultTableComparator);
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    DurbinWatsonResultsView.this.tableViewer.copyToClipboard(DurbinWatsonResultsView.this.titles);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getControl().setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        IChromatogramResult chromatogramResult;
        Object result;
        IChromatogramResult object;
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection) && (object = chromatogramSelection.getChromatogram().getChromatogramResult("org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson")) instanceof IChromatogramResult && (result = (chromatogramResult = object).getResult()) instanceof IDurbinWatsonClassifierResult) {
            this.update((IDurbinWatsonClassifierResult)result, forceReload);
        }
    }

    public void update(IDurbinWatsonClassifierResult durbinWatsonClassifierResult, boolean forceReload) {
        if (this.isPartVisible() && durbinWatsonClassifierResult != null) {
            this.tableViewer.setInput((Object)durbinWatsonClassifierResult);
        }
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        DurbinWatsonResultsView.this.tableViewer.copyToClipboard(DurbinWatsonResultsView.this.titles);
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
    }
}

