/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractEntryEditDialog
extends Dialog {
    private static final int NUMBER_OF_COLUMNS = 3;
    private String title;
    private String message;
    private Label messageLabel;
    private Map<String, String> widgetInput;

    public AbstractEntryEditDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.widgetInput = new HashMap<String, String>();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setErrorMessage("Please fill in/edit the fields.");
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.createMessage(composite);
        return composite;
    }

    protected String getWidgetInput(String key) {
        return this.widgetInput.get(key);
    }

    private void createMessage(Composite parent) {
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        layoutData.horizontalSpan = 3;
        layoutData.heightHint = 50;
        if (this.message != null) {
            this.messageLabel = new Label(parent, 64);
            this.messageLabel.setText(this.message);
            this.messageLabel.setLayoutData((Object)layoutData);
            this.messageLabel.setFont(parent.getFont());
            this.messageLabel.setBackground(Display.getCurrent().getSystemColor(1));
        }
    }

    protected void createTextInput(Composite parent, GridData layoutData, final String labelText, String labelUnit, String textDefault, boolean editable) {
        this.createLabel(parent, labelText);
        final Text text = new Text(parent, 2048);
        text.setText(textDefault);
        text.setLayoutData((Object)layoutData);
        this.widgetInput.put(labelText, text.getText());
        text.setEditable(editable);
        text.setEnabled(editable);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AbstractEntryEditDialog.this.widgetInput.put(labelText, text.getText());
                AbstractEntryEditDialog.this.validateInput();
            }
        });
        this.createLabel(parent, labelUnit);
    }

    protected void createCheckInput(Composite parent, GridData layoutData, final String labelText, String labelUnit, boolean selectionDefault) {
        this.createLabel(parent, labelText);
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)layoutData);
        button.setSelection(selectionDefault);
        this.widgetInput.put(labelText, Boolean.toString(selectionDefault));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEntryEditDialog.this.widgetInput.put(labelText, Boolean.toString(button.getSelection()));
                AbstractEntryEditDialog.this.validateInput();
            }
        });
        this.createLabel(parent, labelUnit);
    }

    protected void createEnumInput(Composite parent, GridData layoutData, final String labelText, String labelUnit, String[] items, String textDefault) {
        this.createLabel(parent, labelText);
        final Combo combo = new Combo(parent, 0);
        combo.setItems(items);
        combo.setLayoutData((Object)layoutData);
        combo.setText(textDefault);
        this.widgetInput.put(labelText, combo.getText());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEntryEditDialog.this.widgetInput.put(labelText, combo.getText());
                AbstractEntryEditDialog.this.validateInput();
            }
        });
        this.createLabel(parent, labelUnit);
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    protected boolean validateInput() {
        boolean valid = false;
        for (Map.Entry<String, String> entry : this.widgetInput.entrySet()) {
            String text = entry.getValue();
            if (text == null || text.equals("")) {
                this.setErrorMessage(String.valueOf(entry.getKey()) + " must be not null or empty.");
                break;
            }
            valid = true;
        }
        if (valid) {
            this.setErrorMessage("");
        }
        return valid;
    }

    protected void setErrorMessage(String errorMessage) {
        Button button = this.getButton(0);
        if (errorMessage != null && !errorMessage.equals("")) {
            this.messageLabel.setForeground(Display.getCurrent().getSystemColor(3));
            this.messageLabel.setText(errorMessage);
            if (button != null) {
                button.setEnabled(false);
            }
        } else {
            if (this.messageLabel != null && !this.messageLabel.isDisposed()) {
                this.messageLabel.setForeground(Display.getCurrent().getSystemColor(2));
                this.messageLabel.setText(this.message);
            }
            if (button != null) {
                button.setEnabled(true);
            }
        }
    }
}

