/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.core.ISupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.AbstractProcessTypeSupplier;
import org.eclipse.chemclipse.chromatogram.msd.process.support.IProcessTypeSupplier;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentifierTypeSupplier
extends AbstractProcessTypeSupplier
implements IProcessTypeSupplier {
    public static final String CATEGORY = "Peak Identifier";

    @Override
    public String getCategory() {
        return CATEGORY;
    }

    @Override
    public String getProcessorName(String processorId) throws Exception {
        ISupplier peakIdentifierSupplier = PeakIdentifier.getPeakIdentifierSupport().getIdentifierSupplier(processorId);
        return peakIdentifierSupplier.getIdentifierName();
    }

    @Override
    public List<String> getPluginIds() throws Exception {
        return PeakIdentifier.getPeakIdentifierSupport().getAvailableIdentifierIds();
    }

    @Override
    public IProcessingInfo applyProcessor(IChromatogramSelectionMSD chromatogramSelection, String processorId, IProgressMonitor monitor) {
        return PeakIdentifier.identify(this.getPeakList(chromatogramSelection), (String)processorId, (IProgressMonitor)monitor);
    }

    private List<IPeakMSD> getPeakList(IChromatogramSelectionMSD chromatogramSelection) {
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        List peaks = chromatogram.getPeaks(chromatogramSelection);
        ArrayList<IPeakMSD> peakList = new ArrayList<IPeakMSD>();
        for (IChromatogramPeakMSD chromatogramPeak : peaks) {
            peakList.add((IPeakMSD)chromatogramPeak);
        }
        return peakList;
    }
}

