/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.fieldeditors;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ExtendedLabelFieldEditor
extends FieldEditor {
    private Label infoLabel;
    private String errorMessage;
    private String EXTENDED_LABEL_PREFERENCE_NAME = "extendedLabelFieldEditor";
    private Color color;

    public ExtendedLabelFieldEditor(String label, String info, Composite parent) {
        this(label, info, null, parent);
    }

    public ExtendedLabelFieldEditor(String label, String info, Color color, Composite parent) {
        this.init(this.EXTENDED_LABEL_PREFERENCE_NAME, label);
        this.errorMessage = "";
        this.color = color;
        this.createControl(parent);
        this.getInfoControl(parent).setText(info);
    }

    public ExtendedLabelFieldEditor(String label, int info, Color color, Composite parent) {
        this(label, Integer.valueOf(info).toString(), color, parent);
    }

    public ExtendedLabelFieldEditor(String label, int info, Composite parent) {
        this(label, Integer.valueOf(info).toString(), null, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.infoLabel.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.infoLabel = this.getInfoControl(parent);
        GridData gridData = new GridData();
        gridData.horizontalSpan = numColumns - 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.infoLabel.setLayoutData((Object)gridData);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Label getInfoControl(Composite parent) {
        if (this.infoLabel == null) {
            this.infoLabel = new Label(parent, 0);
            this.infoLabel.setFont(parent.getFont());
            if (this.color != null) {
                this.infoLabel.setForeground(this.color);
            }
        }
        return this.infoLabel;
    }

    public boolean isValid() {
        return true;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.infoLabel != null) {
            this.infoLabel.setFocus();
        }
    }

    public void setInfoLabelText(String text) {
        if (this.infoLabel != null) {
            this.infoLabel.setText(text);
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }
}

