/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.config;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DefaultSelectionStyleConfiguration
extends AbstractRegistryConfiguration {
    public Font selectionFont = GUIHelper.getFont(new FontData("Verdana", 8, 3));
    public Color selectionBgColor = GUIHelper.COLOR_TITLE_INACTIVE_BACKGROUND;
    public Color selectionFgColor = GUIHelper.COLOR_BLACK;
    public Color anchorBorderColor = GUIHelper.COLOR_DARK_GRAY;
    public BorderStyle anchorBorderStyle = new BorderStyle(1, this.anchorBorderColor, BorderStyle.LineStyleEnum.SOLID);
    public Color anchorBgColor = GUIHelper.COLOR_GRAY;
    public Color anchorFgColor = GUIHelper.COLOR_WHITE;
    public Color selectedHeaderBgColor = GUIHelper.COLOR_GRAY;
    public Color selectedHeaderFgColor = GUIHelper.COLOR_WHITE;
    public Font selectedHeaderFont = GUIHelper.getFont(new FontData("Verdana", 10, 1));
    public BorderStyle selectedHeaderBorderStyle = new BorderStyle(-1, this.selectedHeaderFgColor, BorderStyle.LineStyleEnum.SOLID);
    public Color fullySelectedHeaderBgColor = GUIHelper.COLOR_WIDGET_NORMAL_SHADOW;
    public Color anchorGridBorderColor = GUIHelper.COLOR_BLACK;
    public BorderStyle anchorGridBorderStyle = new BorderStyle(1, this.anchorGridBorderColor, BorderStyle.LineStyleEnum.DOTTED);

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        this.configureSelectionStyle(configRegistry);
        this.configureSelectionAnchorStyle(configRegistry);
        this.configureSelectionAnchorGridLineStyle(configRegistry);
        this.configureHeaderHasSelectionStyle(configRegistry);
        this.configureHeaderFullySelectedStyle(configRegistry);
    }

    protected void configureSelectionStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.selectionFont);
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.selectionBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.selectionFgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT");
    }

    protected void configureSelectionAnchorStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.anchorBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "NORMAL", "selectionAnchor");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.anchorBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.anchorFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.anchorBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "selectionAnchor");
    }

    protected void configureSelectionAnchorGridLineStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.anchorGridBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "selectionAnchorGridLine");
    }

    protected void configureHeaderHasSelectionStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.selectedHeaderFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.selectedHeaderBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.selectedHeaderFont);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.selectedHeaderBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "CORNER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "ROW_HEADER");
    }

    protected void configureHeaderFullySelectedStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.fullySelectedHeaderBgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "COLUMN_HEADER_FULL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "SELECT", "ROW_HEADER_FULL");
    }
}

