/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.Range;

class CubePositionRangeFilter {
    private Range[][] dimPosRanges;

    CubePositionRangeFilter(IDiskArray[] invalidDimPosArray) throws IOException {
        this.dimPosRanges = new Range[invalidDimPosArray.length][];
        int i = 0;
        while (i < invalidDimPosArray.length) {
            this.dimPosRanges[i] = this.convertToRanges(invalidDimPosArray[i]);
            ++i;
        }
    }

    private Range[] convertToRanges(IDiskArray dimPosArray) throws IOException {
        Range range;
        int start;
        ArrayList<Range> rangeList = new ArrayList<Range>();
        int last = start = ((Integer)dimPosArray.get(0)).intValue();
        int i = 1;
        while (i < dimPosArray.size()) {
            int currentPos = (Integer)dimPosArray.get(i);
            if (currentPos != last + 1) {
                range = new Range(start, last);
                rangeList.add(range);
                start = currentPos;
            }
            last = currentPos;
            ++i;
        }
        range = new Range(start, last);
        rangeList.add(range);
        Range[] result = new Range[rangeList.size()];
        int i2 = 0;
        while (i2 < rangeList.size()) {
            result[i2] = (Range)rangeList.get(i2);
            ++i2;
        }
        return result;
    }

    boolean match(int[] dimPositions) {
        int i = 0;
        while (i < this.dimPosRanges.length) {
            boolean match = false;
            int j = 0;
            while (j < this.dimPosRanges[i].length) {
                if (this.dimPosRanges[i][j].match(dimPositions[i])) {
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

