/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.util.HashMap;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ser.ReadOnlyClassToSerializerMap;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializerCache {
    private HashMap<Object, JsonSerializer<Object>> _sharedMap = new HashMap(64);
    private ReadOnlyClassToSerializerMap _readOnlyMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m;
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            m = this._readOnlyMap;
            if (m == null) {
                this._readOnlyMap = m = ReadOnlyClassToSerializerMap.from(this._sharedMap);
            }
        }
        return m.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(Class<?> type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new UntypedKeyRaw(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(JavaType type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(JavaType type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypedKeyFull(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(Class<?> cls) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypedKeyRaw(cls));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(JavaType type, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypedKeyFull(type), ser) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(Class<?> cls, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypedKeyRaw(cls), ser) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonTypedSerializer(Class<?> type, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new UntypedKeyRaw(type), ser) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonTypedSerializer(JavaType type, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(type, ser) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    public synchronized int size() {
        return this._sharedMap.size();
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }

    public static final class TypedKeyFull {
        JavaType _type;

        public TypedKeyFull(JavaType type) {
            this._type = type;
        }

        public void reset(JavaType type) {
            this._type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return ((TypedKeyFull)o)._type.equals((Object)this._type);
        }

        public int hashCode() {
            return this._type.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TypedKeyRaw {
        Class<?> _type;
        int _hashCode;

        public TypedKeyRaw(Class<?> cls) {
            this.reset(cls);
        }

        public void reset(Class<?> cls) {
            this._type = cls;
            this._hashCode = cls.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return ((TypedKeyRaw)o)._type == this._type;
        }

        public int hashCode() {
            return this._hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UntypedKeyRaw {
        Class<?> _type;
        int _hashCode;

        public UntypedKeyRaw(Class<?> cls) {
            this.reset(cls);
        }

        public void reset(Class<?> cls) {
            this._type = cls;
            this._hashCode = cls.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return ((UntypedKeyRaw)o)._type == this._type;
        }

        public int hashCode() {
            return this._hashCode;
        }
    }
}

