/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.converter;

import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;

public class SeriesConverterWSD {
    public static final Logger logger = Logger.getLogger(SeriesConverterWSD.class);

    private SeriesConverterWSD() {
    }

    public static ISeries convertSupplierScan(IScanWSD supplierScan, Sign sign) {
        ISeries scanSeries = null;
        if (supplierScan != null) {
            List scanSignals = supplierScan.getScanSignals();
            int size = scanSignals.size();
            double[] xSeries = new double[size];
            double[] ySeries = new double[size];
            int x = 0;
            int y = 0;
            for (IScanSignalWSD scanSignal : scanSignals) {
                xSeries[x++] = scanSignal.getWavelength();
                double signal = scanSignal.getAbundance();
                if (sign == Sign.NEGATIVE) {
                    signal *= -1.0;
                }
                ySeries[y++] = signal;
            }
            scanSeries = new Series(xSeries, ySeries, "Supplier Scan");
        } else {
            scanSeries = SeriesConverterWSD.getZeroScanSeries();
        }
        return scanSeries;
    }

    public static IMultipleSeries convertChromatogram(IChromatogramSelectionWSD chromatogramSelection, List<Integer> wavelengths, boolean combine, Sign sign) {
        MultipleSeries wavelengthSeries = new MultipleSeries();
        if (chromatogramSelection != null) {
            IChromatogramWSD chromatogram = chromatogramSelection.getChromatogramWSD();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            int scans = stopScan - startScan + 1;
            for (Integer wavelength : wavelengths) {
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                int i = startScan;
                while (i <= stopScan) {
                    IScan scan = chromatogram.getScan(i);
                    if (scan instanceof IScanWSD) {
                        IScanWSD scanWSD = (IScanWSD)scan;
                        List scanSignals = scanWSD.getScanSignals();
                        double retentionTime = scanWSD.getRetentionTime();
                        double abundance = SeriesConverterWSD.getIntensityWavelength(scanSignals, wavelength);
                        xSeries[x++] = retentionTime;
                        ySeries[y++] = abundance;
                    }
                    ++i;
                }
                Series series = new Series(xSeries, ySeries, "nm: " + wavelength);
                wavelengthSeries.add((ISeries)series);
            }
        }
        return wavelengthSeries;
    }

    private static double getIntensityWavelength(List<IScanSignalWSD> scanSignals, int wavelength) {
        for (IScanSignalWSD scanSignal : scanSignals) {
            if (scanSignal.getWavelength() != wavelength) continue;
            return scanSignal.getAbundance();
        }
        return 0.0;
    }

    private static ISeries getZeroScanSeries() {
        double[] xSeries = new double[]{0.0, 0.0};
        double[] ySeries = new double[]{0.0, 0.0};
        return new Series(xSeries, ySeries, "no profile available");
    }
}

