/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.definitions;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.rcp.app.ui.addons.ModelSupportAddon;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LibraryType
implements EventHandler {
    public static final String LIBRARY_TYPE = "org.eclipse.chemclipse.ux.extension.ui.definitions.libraryType";
    public static final String LIBRARY_SELECTION = "org.eclipse.chemclipse.ux.extension.ui.librarySelection";
    public static final String LIBRARY_TYPE_MSD = "LIBRARY_TYPE_MSD";
    public static final String LIBRARY_TYPE_NONE = "LIBRARY_TYPE_NONE";

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        Object property = event.getProperty("org.eclipse.e4.data");
        IMassSpectra librarySelection = null;
        String libraryType = LIBRARY_TYPE_NONE;
        if (topic.equals("library/msd/update/selection")) {
            librarySelection = (IMassSpectra)property;
            libraryType = LIBRARY_TYPE_MSD;
        } else if (topic.equals("library/msd/unload/selection")) {
            librarySelection = null;
            libraryType = LIBRARY_TYPE_NONE;
        }
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        if (eclipseContext != null) {
            eclipseContext.set(LIBRARY_SELECTION, (Object)librarySelection);
            eclipseContext.set(LIBRARY_TYPE, (Object)libraryType);
        }
    }

    public static IMassSpectra getMassSpectra() {
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        Object object = eclipseContext.get(LIBRARY_SELECTION);
        IMassSpectra massSpectra = null;
        if (object != null && object instanceof IChromatogramSelection) {
            massSpectra = (IMassSpectra)object;
        }
        return massSpectra;
    }
}

