/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.CombinedIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.CombinedIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.ICombinedIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.ICombinedIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.combined.ICombinedIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.CombinedIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.ICombinedIntegratorProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class CombinedIntegrator {
    private static final Logger logger = Logger.getLogger(CombinedIntegrator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.integrator.combinedIntegratorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String INTEGRATOR_NAME = "integratorName";
    private static final String INTEGRATOR = "integrator";
    private static final String NO_INTEGRATOR_AVAILABLE = "There is no combined integrator available.";

    private CombinedIntegrator() {
    }

    public static ICombinedIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, ICombinedIntegrationSettings combinedIntegrationSettings, String integratorId, IProgressMonitor monitor) {
        ICombinedIntegrator integrator = CombinedIntegrator.getCombinedIntegrator(integratorId);
        ICombinedIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(chromatogramSelection, combinedIntegrationSettings, monitor) : CombinedIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static ICombinedIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, String integratorId, IProgressMonitor monitor) {
        return CombinedIntegrator.integrate(chromatogramSelection, CombinedIntegrator.getCombinedIntegrator(integratorId), monitor);
    }

    public static ICombinedIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, ICombinedIntegrator integrator, IProgressMonitor monitor) {
        ICombinedIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(chromatogramSelection, monitor) : CombinedIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static ICombinedIntegratorSupport getCombinedIntegratorSupport() {
        IConfigurationElement[] extensions;
        CombinedIntegratorSupport integratorSupport = new CombinedIntegratorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            CombinedIntegratorSupplier supplier = new CombinedIntegratorSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setIntegratorName(element.getAttribute(INTEGRATOR_NAME));
            integratorSupport.add(supplier);
            ++n2;
        }
        return integratorSupport;
    }

    private static ICombinedIntegrator getCombinedIntegrator(String integratorId) {
        IConfigurationElement element = CombinedIntegrator.getConfigurationElement(integratorId);
        ICombinedIntegrator instance = null;
        if (element != null) {
            try {
                instance = (ICombinedIntegrator)element.createExecutableExtension(INTEGRATOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String integratorId) {
        IConfigurationElement[] elements;
        if ("".equals(integratorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(integratorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static ICombinedIntegratorProcessingInfo getNoIntegratorAvailableProcessingInfo() {
        CombinedIntegratorProcessingInfo processingInfo = new CombinedIntegratorProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Combined Integrator", NO_INTEGRATOR_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

