/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.chromatogram;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramSupplier;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.chromatogram.IChromatogramCSDExportConverter;
import org.eclipse.chemclipse.csd.converter.chromatogram.IChromatogramCSDImportConverter;
import org.eclipse.chemclipse.csd.converter.processing.chromatogram.ChromatogramCSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.processing.chromatogram.IChromatogramCSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramConverterCSD {
    private static final Logger logger = Logger.getLogger(ChromatogramConverterCSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.csd.converter.chromatogramSupplier";

    private ChromatogramConverterCSD() {
    }

    public static IChromatogramCSDImportConverterProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        IChromatogramCSDImportConverter importConverter = ChromatogramConverterCSD.getChromatogramImportConverter(converterId);
        IChromatogramCSDImportConverterProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : ChromatogramConverterCSD.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramCSDImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = ChromatogramConverterCSD.getChromatogram(file, false, monitor);
        ChromatogramCSDImportConverterProcessingInfo processingInfoImport = new ChromatogramCSDImportConverterProcessingInfo();
        processingInfoImport.addMessages(processingInfo);
        processingInfoImport.setProcessingResult(processingInfo.getProcessingResult());
        return processingInfoImport;
    }

    private static IProcessingInfo getChromatogram(File file, boolean overview, IProgressMonitor monitor) {
        ChromatogramConverterSupport converterSupport = ChromatogramConverterCSD.getChromatogramConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                Object object;
                Object processingInfo;
                IChromatogramCSDImportConverter importConverter = ChromatogramConverterCSD.getChromatogramImportConverter(converterId);
                if (importConverter == null || !(overview ? !(processingInfo = importConverter.convertOverview(file, monitor)).hasErrorMessages() && (object = processingInfo.getProcessingResult()) instanceof IChromatogramOverview : !(processingInfo = importConverter.convert(file, monitor)).hasErrorMessages() && (object = processingInfo.getProcessingResult()) instanceof IChromatogramCSD)) continue;
                return processingInfo;
            }
        }
        catch (NoConverterAvailableException e) {
            logger.info((Object)e);
        }
        return ChromatogramConverterCSD.getNoImportConverterAvailableProcessingInfo(file);
    }

    public static IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, String converterId, IProgressMonitor monitor) {
        IChromatogramCSDImportConverter importConverter = ChromatogramConverterCSD.getChromatogramImportConverter(converterId);
        IChromatogramOverviewImportConverterProcessingInfo processingInfo = importConverter != null ? importConverter.convertOverview(file, monitor) : ChromatogramConverterCSD.getNoOverviewImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = ChromatogramConverterCSD.getChromatogram(file, true, monitor);
        ChromatogramOverviewImportConverterProcessingInfo processingInfoImport = new ChromatogramOverviewImportConverterProcessingInfo();
        processingInfoImport.addMessages(processingInfo);
        processingInfoImport.setProcessingResult(processingInfo.getProcessingResult());
        return processingInfoImport;
    }

    public static IChromatogramExportConverterProcessingInfo convert(File file, IChromatogramCSD chromatogram, String converterId, IProgressMonitor monitor) {
        IChromatogramCSDExportConverter exportConverter = ChromatogramConverterCSD.getChromatogramExportConverter(converterId);
        IChromatogramExportConverterProcessingInfo processingInfo = exportConverter != null ? exportConverter.convert(file, chromatogram, monitor) : ChromatogramConverterCSD.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static IChromatogramCSDImportConverter getChromatogramImportConverter(String converterId) {
        IConfigurationElement element = ChromatogramConverterCSD.getConfigurationElement(converterId);
        IChromatogramCSDImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramCSDImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IChromatogramCSDExportConverter getChromatogramExportConverter(String converterId) {
        IConfigurationElement element = ChromatogramConverterCSD.getConfigurationElement(converterId);
        IChromatogramCSDExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramCSDExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static ChromatogramConverterSupport getChromatogramConverterSupport() {
        IConfigurationElement[] extensions;
        ChromatogramConverterSupport chromatogramConverterSupport = new ChromatogramConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramSupplier supplier = new ChromatogramSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")).booleanValue());
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")).booleanValue());
                supplier.setMagicNumberMatcher(ChromatogramConverterCSD.getMagicNumberMatcher(element));
                chromatogramConverterSupport.add((ISupplier)supplier);
            }
            ++n2;
        }
        return chromatogramConverterSupport;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception exception) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    private static IChromatogramExportConverterProcessingInfo getNoExportConverterAvailableProcessingInfo(File file) {
        ChromatogramExportConverterProcessingInfo processingInfo = new ChromatogramExportConverterProcessingInfo();
        processingInfo.addErrorMessage("Chromatogram Export Converter", "There is no suitable converter available to save the chromatogram to the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static IChromatogramCSDImportConverterProcessingInfo getNoImportConverterAvailableProcessingInfo(File file) {
        ChromatogramCSDImportConverterProcessingInfo processingInfo = new ChromatogramCSDImportConverterProcessingInfo();
        processingInfo.addErrorMessage("Chromatogram Import Converter", "There is no suitable converter available to load the chromatogram from the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static IChromatogramOverviewImportConverterProcessingInfo getNoOverviewImportConverterAvailableProcessingInfo(File file) {
        ChromatogramOverviewImportConverterProcessingInfo processingInfo = new ChromatogramOverviewImportConverterProcessingInfo();
        processingInfo.addErrorMessage("ChromatogramOverview Import Converter", "There is no suitable converter available to load the chromatogram overview from the file: " + file.getAbsolutePath());
        return processingInfo;
    }
}

