/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.IMassSpectrumSelectionView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.ScanType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractMassSpectrumSelectionView
extends AbstractSelectionView
implements IMassSpectrumSelectionView {
    private IScanMSD massSpectrum;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractMassSpectrumSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IScanMSD getMassSpectrum() {
        if (this.massSpectrum == null) {
            this.massSpectrum = ScanType.getSelectedScanMSD();
        }
        return this.massSpectrum;
    }

    @Override
    public void setMassSpectrum(IScanMSD massSpectrum) {
        this.massSpectrum = massSpectrum;
    }

    @Override
    public boolean doUpdate(IScanMSD massSpectrum) {
        return this.isPartVisible() && massSpectrum != null;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractMassSpectrumSelectionView.this.massSpectrum = (IScanMSD)event.getProperty("MassSpectrum");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractMassSpectrumSelectionView.this.update(AbstractMassSpectrumSelectionView.this.massSpectrum, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/massspectrum", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

