/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.chromatogram.EditorChromatogramUI;
import org.eclipse.chemclipse.msd.swt.ui.components.ions.MarkedIonsChooser;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.msd.ui.editors.IChromatogramEditorMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.IonTransitionCheckBoxEditingSupport;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.IonTransitionContentProvider;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.IonTransitionLabelProvider;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.IonTransitionTableComparator;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.ChromatogramImportRunnable;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.ChromatogramFileSupport;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.ChromatogramSupport;
import org.eclipse.chemclipse.ux.extension.ui.dialogs.ReferencedChromatogramDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramEditorMSD
implements IChromatogramEditorMSD,
IChromatogramSelectionMSDUpdateNotifier {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
    public static final String TOOLTIP = "Chromatogram - Detector Type: MSD";
    private static final Logger logger = Logger.getLogger(ChromatogramEditorMSD.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private File chromatogramFile;
    private ChromatogramSelectionMSD chromatogramSelection;
    private EditorChromatogramUI chromatogramUI;
    private MarkedIonsChooser selectedIonChooser;
    private MarkedIonsChooser excludedIonChooser;
    private int chromatogramPageIndex;
    private int optionsPageIndex;
    private int infoPageIndex;
    private int ionTransitionsPageIndex;
    private int referencedChromatogramPageIndex;
    private TabFolder tabFolder;
    private Button buttonOverlay;
    private CLabel labelChromatogramRetentionTimeRange;
    private Text textStartRetentionTime;
    private Text textStopRetentionTime;
    private Button buttonLockOffset;
    private FormToolkit formToolkit;

    @PostConstruct
    private void createControl(Composite parent) {
        this.subscribe();
        this.loadChromatogram();
        this.createPages(parent);
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.update(true);
        }
    }

    @Focus
    public void setFocus() {
        if (this.tabFolder != null) {
            this.tabFolder.setFocus();
            if (this.tabFolder.getSelectionIndex() == this.chromatogramPageIndex && this.chromatogramSelection != null) {
                this.chromatogramSelection.update(false);
            }
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
        ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange(null, (boolean)true);
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.getChromatogram().setUnloaded();
            this.chromatogramSelection.dispose();
        }
        if (this.modelService != null) {
            final MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    partStack.getChildren().remove(ChromatogramEditorMSD.this.part);
                }
            });
        }
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
        System.gc();
    }

    @Persist
    public void save() {
        final Shell shell = Display.getDefault().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Chromatogram", -1);
                    try {
                        ChromatogramEditorMSD.this.saveChromatogram(monitor, shell);
                    }
                    catch (NoChromatogramConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    private void saveChromatogram(IProgressMonitor monitor, Shell shell) throws NoChromatogramConverterAvailableException {
        if (this.chromatogramSelection != null && shell != null) {
            IChromatogramMSD chromatogram = this.chromatogramSelection.getChromatogramMSD();
            String converterId = chromatogram.getConverterId();
            if (converterId != null && !converterId.equals("") && this.chromatogramFile != null) {
                monitor.subTask("Save Chromatogram");
                IChromatogramExportConverterProcessingInfo processingInfo = ChromatogramConverterMSD.convert((File)this.chromatogramFile, (IChromatogramMSD)chromatogram, (String)converterId, (IProgressMonitor)monitor);
                try {
                    processingInfo.getFile();
                    this.dirtyable.setDirty(false);
                }
                catch (TypeCastException typeCastException) {
                    throw new NoChromatogramConverterAvailableException();
                }
            } else {
                throw new NoChromatogramConverterAvailableException();
            }
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.chromatogramSelection != null) {
            try {
                saveSuccessful = ChromatogramFileSupport.saveChromatogram(this.chromatogramSelection.getChromatogramMSD());
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    @Override
    public IChromatogramSelectionMSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.fireUpdate(chromatogramSelection, forceReload)) {
            int selectionIndex;
            if (forceReload) {
                this.dirtyable.setDirty(true);
            }
            if ((selectionIndex = this.tabFolder.getSelectionIndex()) == this.optionsPageIndex) {
                this.updateOptionsPageValues();
            } else if (selectionIndex == this.infoPageIndex) {
                this.updateInfoPageValues();
            } else if (selectionIndex == this.ionTransitionsPageIndex) {
                this.updateIonTransitionPageValues();
            }
            this.chromatogramUI.update(chromatogramSelection, forceReload);
        }
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionMSD selection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    ChromatogramEditorMSD.this.update(selection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private void loadChromatogram() {
        try {
            Object object = this.part.getObject();
            if (object instanceof String) {
                File file = new File((String)object);
                this.importChromatogram(file);
            } else if (object instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogram = (IChromatogramMSD)object;
                this.chromatogramSelection = new ChromatogramSelectionMSD((IChromatogram)chromatogram);
                this.chromatogramFile = null;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private void importChromatogram(File file) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        ChromatogramImportRunnable runnable = new ChromatogramImportRunnable(file, this.chromatogramSelection);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.chromatogramSelection = runnable.getChromatogramSelection();
        this.chromatogramFile = file;
        int sizeReferencedChromatograms = this.chromatogramSelection.getChromatogramMSD().getReferencedChromatograms().size();
        if (sizeReferencedChromatograms > 0) {
            ReferencedChromatogramDialog referencedChromatogramDialog = new ReferencedChromatogramDialog(Display.getCurrent().getActiveShell(), this.chromatogramSelection.getChromatogram());
            referencedChromatogramDialog.create();
            if (referencedChromatogramDialog.open() == 0) {
                List selectedChromatograms = referencedChromatogramDialog.getSelectedChromatograms();
                for (IChromatogram chromatogram : selectedChromatograms) {
                    ChromatogramSupport.getInstanceEditorSupport().openEditor(chromatogram, this.modelService, this.application, this.partService);
                }
            }
        }
    }

    private void createPages(Composite parent) {
        if (this.chromatogramSelection != null && this.chromatogramSelection.getChromatogramMSD() != null) {
            this.part.setLabel(this.chromatogramSelection.getChromatogramMSD().getName());
            this.tabFolder = new TabFolder(parent, 1024);
            this.createChromatogramPage();
            this.chromatogramPageIndex = 0;
            this.createOptionsPage();
            this.optionsPageIndex = 1;
            this.createInfoPage();
            this.infoPageIndex = 2;
            this.createIonTransitionPage();
            this.ionTransitionsPageIndex = 3;
            this.createReferencedChromatogramPage();
            this.referencedChromatogramPageIndex = 4;
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ChromatogramEditorMSD.this.tabFolder.getSelectionIndex();
                    if (ChromatogramEditorMSD.this.chromatogramSelection != null) {
                        switch (index) {
                            case 0: {
                                ChromatogramEditorMSD.this.update((IChromatogramSelectionMSD)ChromatogramEditorMSD.this.chromatogramSelection, false);
                                break;
                            }
                            case 1: {
                                ChromatogramEditorMSD.this.updateOptionsPageValues();
                                break;
                            }
                            case 2: {
                                ChromatogramEditorMSD.this.updateInfoPageValues();
                                break;
                            }
                            case 3: {
                                ChromatogramEditorMSD.this.updateIonTransitionPageValues();
                                break;
                            }
                        }
                    }
                }
            });
        } else {
            this.createErrorMessagePage(parent);
        }
    }

    private void updateOptionsPageValues() {
        if (this.selectedIonChooser != null && this.excludedIonChooser != null) {
            this.selectedIonChooser.setMarkedIons(this.chromatogramSelection.getSelectedIons());
            this.excludedIonChooser.setMarkedIons(this.chromatogramSelection.getExcludedIons());
        }
    }

    private void updateInfoPageValues() {
        if (this.buttonOverlay != null) {
            this.buttonOverlay.setSelection(this.chromatogramSelection.isOverlaySelected());
        }
        if (this.labelChromatogramRetentionTimeRange != null) {
            IChromatogramMSD chromatogram = this.chromatogramSelection.getChromatogramMSD();
            String minRetentionTime = this.decimalFormat.format((double)chromatogram.getStartRetentionTime() / 60000.0);
            String maxRetentionTime = this.decimalFormat.format((double)chromatogram.getStopRetentionTime() / 60000.0);
            this.labelChromatogramRetentionTimeRange.setText("Chromatogram (Minutes): " + minRetentionTime + " - " + maxRetentionTime);
        }
        if (this.textStartRetentionTime != null && this.textStopRetentionTime != null) {
            this.textStartRetentionTime.setText(this.decimalFormat.format((double)this.chromatogramSelection.getStartRetentionTime() / 60000.0));
            this.textStopRetentionTime.setText(this.decimalFormat.format((double)this.chromatogramSelection.getStopRetentionTime() / 60000.0));
        }
        if (this.buttonLockOffset != null) {
            this.buttonLockOffset.setSelection(this.chromatogramSelection.isLockOffset());
        }
    }

    private void updateIonTransitionPageValues() {
    }

    private void createChromatogramPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Chromatogram");
        this.chromatogramUI = new EditorChromatogramUI((Composite)this.tabFolder, 0);
        this.chromatogramUI.setMaster(true);
        this.chromatogramUI.update((IChromatogramSelectionMSD)this.chromatogramSelection, true);
        tabItem.setControl((Control)this.chromatogramUI);
    }

    private void createErrorMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Editor");
        this.createProblemSection(scrolledFormComposite);
        this.createResolutionSection(scrolledFormComposite);
    }

    private void createProblemSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Problem");
        section.setDescription("There has gone something wrong to open the chromatogram.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.createLabel(client, "The chromatogram couldn't be loaded.", "warn.gif");
        this.createLabel(client, "Does the selected chromatogram contains data recorded by a mass spectrometer?", "question.gif");
        this.createLabel(client, "Is the data file corrupted?", "question.gif");
        this.createLabel(client, "Is an appropriate file format converter installed?", "question.gif");
        this.createLink(client, "Converters can be installed using the marketplace.", "https://marketplace.openchrom.net");
        this.createLabel(client, "Does the converter has a valid license? (Menu -> Window -> Preferences -> Converter)", "question.gif");
        this.createLink(client, "Create a log-in and retrieve free serial keys.", "https://marketplace.openchrom.net");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createResolutionSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Further Questions");
        section.setDescription("The developers may have a solution for you.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.createLabel(client, "FID data is also supported.", "info.gif");
        this.createLink(client, "Please contact the developers, if you have further questions.", "https://www.openchrom.net");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private CLabel createLabel(Composite parent, String text, String image) {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        CLabel label = new CLabel(parent, 16384);
        label.setText(text);
        if (image != null) {
            label.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
        }
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void createReferencedChromatogramHyperlink(Composite parent, int number, final IChromatogramMSD chromatogram) {
        ImageHyperlink imageHyperlink = new ImageHyperlink(parent, 16384);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        imageHyperlink.setText("Chromatogram #" + number);
        imageHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ChromatogramSupport.getInstanceEditorSupport().openOverview((IChromatogramOverview)chromatogram, ChromatogramEditorMSD.this.eventBroker);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                ChromatogramSupport.getInstanceEditorSupport().openEditor((IChromatogram)chromatogram, ChromatogramEditorMSD.this.modelService, ChromatogramEditorMSD.this.application, ChromatogramEditorMSD.this.partService);
            }
        });
    }

    private void createLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.setText(String.valueOf(text) + " (<a>" + url + "</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Program.launch((String)url);
            }
        });
    }

    private void createOptionsPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Options");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Options");
        this.createOptionsPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createOptionsPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Options");
        section.setDescription("This page shows several additional chromatogram options.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.createLabel(client, "Use the selected/excluded ions to inspect the chromatogram using different views.", "info.gif");
        Composite compositeIons = new Composite(client, 0);
        compositeIons.setLayout((Layout)new GridLayout(2, true));
        compositeIons.setLayoutData((Object)new GridData(1808));
        this.selectedIonChooser = new MarkedIonsChooser(compositeIons, 0);
        this.selectedIonChooser.setMarkedIons(this.chromatogramSelection.getSelectedIons());
        this.selectedIonChooser.setLabelText("Add/Remove selected ions");
        this.excludedIonChooser = new MarkedIonsChooser(compositeIons, 0);
        this.excludedIonChooser.setMarkedIons(this.chromatogramSelection.getExcludedIons());
        this.excludedIonChooser.setLabelText("Add/Remove excluded ions");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createInfoPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Info");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Info");
        this.createInfoPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createInfoPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Chromatogram Selection");
        section.setDescription("Display of the current chromatogram selection.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.buttonOverlay = new Button(client, 32);
        this.buttonOverlay.setSelection(this.chromatogramSelection.isOverlaySelected());
        this.buttonOverlay.setText("Show chromatogram in overlay");
        this.buttonOverlay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean overlaySelected = ChromatogramEditorMSD.this.buttonOverlay.getSelection();
                ChromatogramEditorMSD.this.chromatogramSelection.setOverlaySelected(overlaySelected);
            }
        });
        this.labelChromatogramRetentionTimeRange = this.createLabel(client, "Retention Time Range (Chromatogram):", "info.gif");
        this.createLabel(client, "Start Retention Time (Minutes):", null);
        this.textStartRetentionTime = new Text(client, 0);
        this.textStartRetentionTime.setLayoutData((Object)new GridData(768));
        this.createLabel(client, "Stop Retention Time (Minutes):", null);
        this.textStopRetentionTime = new Text(client, 0);
        this.textStopRetentionTime.setLayoutData((Object)new GridData(768));
        Button button = new Button(client, 8);
        button.setText("Set Retention Time Range");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramEditorMSD.this.setRetentionTimeRange();
            }
        });
        Button buttonAll = new Button(client, 8);
        buttonAll.setText("Set Retention Time Range for all open Chromatograms");
        buttonAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramEditorMSD.this.setRetentionTimeRangeForAllOpenChromatograms();
            }
        });
        this.buttonLockOffset = new Button(client, 32);
        this.buttonLockOffset.setSelection(this.chromatogramSelection.isLockOffset());
        this.buttonLockOffset.setText("Lock Offset");
        this.buttonLockOffset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean lockOffset = ChromatogramEditorMSD.this.buttonLockOffset.getSelection();
                ChromatogramEditorMSD.this.chromatogramSelection.setLockOffset(lockOffset);
            }
        });
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void setRetentionTimeRange() {
        String startRetentionTimeText = this.textStartRetentionTime.getText().trim();
        String stopRetentionTimeText = this.textStopRetentionTime.getText().trim();
        try {
            int startRetentionTime = (int)(this.decimalFormat.parse(startRetentionTimeText).doubleValue() * 60000.0);
            int stopRetentionTime = (int)(this.decimalFormat.parse(stopRetentionTimeText).doubleValue() * 60000.0);
            if (startRetentionTime < stopRetentionTime) {
                this.chromatogramSelection.reset();
                this.chromatogramSelection.update(true);
                this.chromatogramSelection.setStartRetentionTime(startRetentionTime);
                this.chromatogramSelection.setStopRetentionTime(stopRetentionTime);
                this.chromatogramUI.updateSelectionManually((IChromatogramSelection)this.chromatogramSelection);
                this.fireUpdate((IChromatogramSelectionMSD)this.chromatogramSelection, true);
            }
        }
        catch (ParseException e) {
            logger.warn((Object)e);
        }
    }

    private void setRetentionTimeRangeForAllOpenChromatograms() {
        String startRetentionTimeText = this.textStartRetentionTime.getText().trim();
        String stopRetentionTimeText = this.textStopRetentionTime.getText().trim();
        try {
            int startRetentionTime = (int)(this.decimalFormat.parse(startRetentionTimeText).doubleValue() * 60000.0);
            int stopRetentionTime = (int)(this.decimalFormat.parse(stopRetentionTimeText).doubleValue() * 60000.0);
            if (startRetentionTime < stopRetentionTime) {
                Collection parts = this.partService.getParts();
                for (MPart part : parts) {
                    Object object;
                    if (!part.getElementId().equals(ID) || (object = part.getObject()) == null || !(object instanceof ChromatogramEditorMSD)) continue;
                    ChromatogramEditorMSD editor = (ChromatogramEditorMSD)object;
                    IChromatogramSelectionMSD selection = editor.getChromatogramSelection();
                    selection.setStartRetentionTime(startRetentionTime);
                    selection.setStopRetentionTime(stopRetentionTime);
                    selection.fireUpdateChange(true);
                }
            }
        }
        catch (ParseException e) {
            logger.warn((Object)e);
        }
    }

    private void createIonTransitionPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Ion Transitions");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        String[] titles = new String[]{"name", "parent m/z", "parent resolution", "daughter m/z", "daughter resolution", "collision energy", "show"};
        int[] bounds = new int[]{250, 100, 150, 100, 150, 150, 60};
        ExtendedTableViewer tableViewer = new ExtendedTableViewer(composite, 68354);
        tableViewer.createColumns(titles, bounds);
        tableViewer.setContentProvider((IContentProvider)new IonTransitionContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new IonTransitionLabelProvider());
        tableViewer.setComparator((ViewerComparator)new IonTransitionTableComparator());
        List tableViewerColumns = tableViewer.getTableViewerColumns();
        TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(6);
        tableViewerColumn.setEditingSupport((EditingSupport)new IonTransitionCheckBoxEditingSupport((TableViewer)tableViewer));
        tableViewer.setInput((Object)this.chromatogramSelection);
        tabItem.setControl((Control)composite);
    }

    private void createReferencedChromatogramPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Referenced Chromatograms");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatograms");
        this.createReferencedChromatogramPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createReferencedChromatogramPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("References");
        section.setDescription("Display of the chromatogram references.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        List references = this.chromatogramSelection.getChromatogram().getReferencedChromatograms();
        int counter = 1;
        for (IChromatogram chromatogram : references) {
            if (!(chromatogram instanceof IChromatogramMSD)) continue;
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
            this.createReferencedChromatogramHyperlink(client, counter++, chromatogramMSD);
        }
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private boolean fireUpdate(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.chromatogramUI == null || chromatogramSelection == null || this.chromatogramSelection == null) {
            return false;
        }
        if (forceReload) {
            return this.chromatogramSelection.getChromatogramMSD() == chromatogramSelection.getChromatogramMSD();
        }
        return this.chromatogramSelection == chromatogramSelection;
    }
}

