/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.gui;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.DialogEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigHelper;
import org.eclipse.nebula.widgets.nattable.edit.EditTypeEnum;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.gui.ICellEditDialog;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractDialogCellEditor
implements ICellEditor,
ICellEditDialog {
    private static final Log log = LogFactory.getLog(AbstractDialogCellEditor.class);
    protected Composite parent;
    protected Object dialog;
    protected ILayerCell layerCell;
    protected DialogEditHandler editHandler = new DialogEditHandler();
    protected IDisplayConverter displayConverter;
    protected IDataValidator dataValidator;
    protected IEditErrorHandler conversionEditErrorHandler;
    protected IEditErrorHandler validationEditErrorHandler;
    protected IConfigRegistry configRegistry;
    protected Map<String, Object> editDialogSettings;

    @Override
    public EditTypeEnum getEditType() {
        return EditTypeEnum.SET;
    }

    @Override
    public Object calculateValue(Object currentValue, Object processValue) {
        return processValue;
    }

    @Override
    public abstract int open();

    @Override
    public Control activateCell(Composite parent, Object originalCanonicalValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
        this.parent = parent;
        this.layerCell = cell;
        this.configRegistry = configRegistry;
        List<String> configLabels = cell.getConfigLabels().getLabels();
        this.displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", configLabels);
        this.dataValidator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", configLabels);
        this.conversionEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.CONVERSION_ERROR_HANDLER, configLabels);
        this.validationEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.VALIDATION_ERROR_HANDLER, configLabels);
        this.dialog = this.createDialogInstance();
        this.setCanonicalValue(originalCanonicalValue);
        return null;
    }

    public abstract Object createDialogInstance();

    public abstract Object getDialogInstance();

    @Override
    public abstract Object getEditorValue();

    @Override
    public abstract void setEditorValue(Object var1);

    @Override
    public Object getCanonicalValue() {
        return this.getCanonicalValue(this.conversionEditErrorHandler);
    }

    @Override
    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        Object canonicalValue;
        try {
            canonicalValue = this.displayConverter != null ? this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, this.getEditorValue()) : this.getEditorValue();
            conversionErrorHandler.removeError(this);
        }
        catch (ConversionFailedException e) {
            conversionErrorHandler.displayError(this, e);
            throw e;
        }
        catch (Exception e) {
            conversionErrorHandler.displayError(this, e);
            throw new ConversionFailedException(e.getMessage(), e);
        }
        return canonicalValue;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue) : canonicalValue;
        this.setEditorValue(displayValue);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue) {
        return this.validateCanonicalValue(canonicalValue, this.validationEditErrorHandler);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue, IEditErrorHandler validationErrorHandler) {
        if (this.dataValidator != null) {
            try {
                boolean validationResult = this.dataValidator.validate(this.layerCell, this.configRegistry, canonicalValue);
                if (!validationResult) {
                    throw new ValidationFailedException(Messages.getString("AbstractCellEditor.validationFailure"));
                }
                this.validationEditErrorHandler.removeError(this);
                return validationResult;
            }
            catch (Exception e) {
                this.validationEditErrorHandler.displayError(this, e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction) {
        return this.commit(direction, true);
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        return this.commit(direction, closeAfterCommit, false);
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit, boolean skipValidation) {
        if (this.editHandler != null && this.dialog != null && !this.isClosed()) {
            try {
                Object canonicalValue = this.getCanonicalValue();
                if (skipValidation || !skipValidation && this.validateCanonicalValue(canonicalValue)) {
                    boolean committed = this.editHandler.commit(canonicalValue, direction);
                    if (committed && closeAfterCommit) {
                        this.close();
                    }
                    return committed;
                }
            }
            catch (ConversionFailedException conversionFailedException) {
            }
            catch (ValidationFailedException validationFailedException) {
            }
            catch (Exception e) {
                log.error((Object)("Error on updating cell value: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Object getCommittedValue() {
        return this.editHandler.getCommittedValue();
    }

    @Override
    public abstract void close();

    @Override
    public abstract boolean isClosed();

    @Override
    public Control getEditorControl() {
        return null;
    }

    @Override
    public Control createEditorControl(Composite parent) {
        return null;
    }

    @Override
    public boolean openInline(IConfigRegistry configRegistry, List<String> configLabels) {
        return false;
    }

    @Override
    public boolean supportMultiEdit(IConfigRegistry configRegistry, List<String> configLabels) {
        return EditConfigHelper.supportMultiEdit(configRegistry, configLabels);
    }

    @Override
    public boolean openMultiEditDialog() {
        return true;
    }

    @Override
    public boolean openAdjacentEditor() {
        return false;
    }

    @Override
    public boolean activateAtAnyPosition() {
        return true;
    }

    @Override
    public boolean activateOnTraversal(IConfigRegistry configRegistry, List<String> configLabels) {
        return EditConfigHelper.activateEditorOnTraversal(configRegistry, configLabels);
    }

    @Override
    public void addEditorControlListeners() {
    }

    @Override
    public void removeEditorControlListeners() {
    }

    @Override
    public Rectangle calculateControlBounds(Rectangle cellBounds) {
        return cellBounds;
    }

    @Override
    public void setDialogSettings(Map<String, Object> editDialogSettings) {
        this.editDialogSettings = editDialogSettings;
    }

    @Override
    public int getColumnIndex() {
        return this.layerCell.getColumnIndex();
    }

    @Override
    public int getRowIndex() {
        return this.layerCell.getRowIndex();
    }

    @Override
    public int getColumnPosition() {
        return this.layerCell.getColumnPosition();
    }

    @Override
    public int getRowPosition() {
        return this.layerCell.getRowPosition();
    }
}

