/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.identification;

import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.swt.ui.components.identification.SynonymsListUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SynonymsEditUI
extends Composite {
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_ADD = "ACTION_ADD";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private SynonymsListUI synonymsListUI;
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private Text textSynonym;
    private Button buttonSynonymAdd;
    private ILibraryInformation libraryInformation;

    public SynonymsEditUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void update(ILibraryInformation libraryInformation, boolean forceReload) {
        if (libraryInformation != null) {
            this.libraryInformation = libraryInformation;
            this.synonymsListUI.setInput(libraryInformation.getSynonyms());
        } else {
            libraryInformation = null;
        }
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createButtonField(composite);
        this.createTableField(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createButtonField(Composite composite) {
        this.textSynonym = new Text(composite, 2048);
        this.textSynonym.setText("");
        this.textSynonym.setLayoutData((Object)new GridData(768));
        this.buttonSynonymAdd = new Button(composite, 8);
        this.buttonSynonymAdd.setText("Add");
        this.buttonSynonymAdd.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        this.buttonSynonymAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                String synonym = SynonymsEditUI.this.textSynonym.getText().trim();
                if ("".equals(synonym)) {
                    MessageBox messageBox = new MessageBox(shell, 40);
                    messageBox.setText("Add synonym");
                    messageBox.setMessage("Please type in a new synonym.");
                    messageBox.open();
                } else if (SynonymsEditUI.this.libraryInformation.getSynonyms().contains(synonym)) {
                    MessageBox messageBox = new MessageBox(shell, 40);
                    messageBox.setText("Add synonym");
                    messageBox.setMessage("The synonym already exists.");
                    messageBox.open();
                } else {
                    SynonymsEditUI.this.libraryInformation.getSynonyms().add(synonym);
                    SynonymsEditUI.this.textSynonym.setText("");
                    SynonymsEditUI.this.synonymsListUI.update(SynonymsEditUI.this.libraryInformation, true);
                    SynonymsEditUI.this.enableButtonFields(SynonymsEditUI.ACTION_INITIALIZE);
                }
            }
        });
        Composite compositeButtons = new Composite(composite, 0);
        compositeButtons.setLayout((Layout)new GridLayout(3, true));
        GridData gridDataComposite = new GridData();
        gridDataComposite.horizontalAlignment = 131072;
        compositeButtons.setLayoutData((Object)gridDataComposite);
        this.buttonCancel = new Button(compositeButtons, 8);
        this.buttonCancel.setImage(ApplicationImageFactory.getInstance().getImage("cancel.gif", "16x16"));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynonymsEditUI.this.enableButtonFields(SynonymsEditUI.ACTION_CANCEL);
            }
        });
        this.buttonDelete = new Button(compositeButtons, 8);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setImage(ApplicationImageFactory.getInstance().getImage("delete.gif", "16x16"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = SynonymsEditUI.this.synonymsListUI.getTable();
                int index = table.getSelectionIndex();
                if (index >= 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 296);
                    messageBox.setText("Delete synonym(s)?");
                    messageBox.setMessage("Would you like to delete the synonym(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        SynonymsEditUI.this.enableButtonFields(SynonymsEditUI.ACTION_DELETE);
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof String) {
                                SynonymsEditUI.this.libraryInformation.getSynonyms().remove(object);
                            }
                            ++n2;
                        }
                        SynonymsEditUI.this.synonymsListUI.update(SynonymsEditUI.this.libraryInformation, true);
                    }
                }
            }
        });
        this.buttonAdd = new Button(compositeButtons, 8);
        this.buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("add.gif", "16x16"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynonymsEditUI.this.enableButtonFields(SynonymsEditUI.ACTION_ADD);
            }
        });
    }

    private void createTableField(Composite composite) {
        Composite compositeTable = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        compositeTable.setLayoutData((Object)gridData);
        compositeTable.setLayout((Layout)new FillLayout());
        this.synonymsListUI = new SynonymsListUI(compositeTable, 2050);
        this.synonymsListUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynonymsEditUI.this.enableButtonFields(SynonymsEditUI.ACTION_SELECT);
            }
        });
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
                this.textSynonym.setEnabled(true);
                this.buttonSynonymAdd.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                if (this.synonymsListUI.getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.textSynonym.setEnabled(enabled);
        this.buttonSynonymAdd.setEnabled(enabled);
    }
}

