/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildpathDelta {
    private final String fOperationDescription;
    private CPListElement[] fNewEntries;
    private final List<IResource> fCreatedResources;
    private IPath fOutputLocation;
    private final List<IResource> fDeletedResources;
    private final List<CPListElement> fAddedEntries;
    private final ArrayList<CPListElement> fRemovedEntries;

    public BuildpathDelta(String operationDescription) {
        this.fOperationDescription = operationDescription;
        this.fCreatedResources = new ArrayList<IResource>();
        this.fDeletedResources = new ArrayList<IResource>();
        this.fAddedEntries = new ArrayList<CPListElement>();
        this.fRemovedEntries = new ArrayList();
    }

    public String getOperationDescription() {
        return this.fOperationDescription;
    }

    public CPListElement[] getNewEntries() {
        return this.fNewEntries;
    }

    public IResource[] getCreatedResources() {
        return this.fCreatedResources.toArray(new IResource[this.fCreatedResources.size()]);
    }

    public IResource[] getDeletedResources() {
        return this.fDeletedResources.toArray(new IResource[this.fDeletedResources.size()]);
    }

    public IPath getDefaultOutputLocation() {
        return this.fOutputLocation;
    }

    public void setNewEntries(CPListElement[] newEntries) {
        this.fNewEntries = newEntries;
    }

    public void addCreatedResource(IResource resource) {
        this.fCreatedResources.add(resource);
    }

    public void setDefaultOutputLocation(IPath outputLocation) {
        this.fOutputLocation = outputLocation;
    }

    public void addDeletedResource(IResource resource) {
        this.fDeletedResources.add(resource);
    }

    public List<CPListElement> getAddedEntries() {
        return this.fAddedEntries;
    }

    public void addEntry(CPListElement entry) {
        this.fAddedEntries.add(entry);
    }

    public List<CPListElement> getRemovedEntries() {
        return this.fRemovedEntries;
    }

    public void removeEntry(CPListElement entry) {
        this.fRemovedEntries.add(entry);
    }
}

